SELECT V.ENTIDADE,
       V.TIPO,
       V.ANO,
       V.NUMERO,
       V.UNIDADE,
       V.NOME,
       V.CODASSUNTO,
       V.DATAORIGEM,
       V.HORAORIGEM,
       V.DATAPROCESSO,
       V.DATADESTINO,
       V.HORADESTINO,
       V.SITUACAO,
       V.STATUSDESCRICAO as STATUS,
       V.USUARIOREG,
       V.DATAREG,
       V.CODPESSOA,
       V.DIGITACAO,
       V.LOCALORIGEM,
       V.LOCALDESTINO,
       V.SENHAINTERNET,
       V.IMOVEL,
       V.ZONA,
       V.QUADRA,
       V.DATA,
       V.CADASTRO,
       V.GERENCIA,
       V.COORDENADORIA,
       V.DIRETORIA,
       V.ASSUNTODESCRICAO,
       V.LOCALDESCRICAO,
       V.UNIDADEDESCRICAO,
       V.ORGAODESCRICAO,
       V.GERENCIADESCRICAO,
       V.PESSOANOME,
       :grupo1 AS GRUPO1,
       :grupo2 AS GRUPO2,
       :grupo3 AS GRUPO3,
       (select max(t.data)
              from tramitacao t
             where t.entidade = v.entidade
               and t.ano = v.ano
               and t.tipo = v.tipo
               and t.numero = v.numero
               and t.funcao = 'A') as dataArquivado
  FROM VW_PROCESSOS V
  WHERE V.ENTIDADE = :entidade
   AND  (:ano = -99 or v.ANO = :ano)
   AND  (v.dataprocesso between :dataprocessoini and :dataprocessofim)
   AND  (:numero = -99 or v.NUMERO = :numero)
   AND  (:assunto = -99 or v.codassunto = :assunto)
   AND  (:tipo = -99 or v.tipo = :tipo)
   AND  (:pessoa = -99 or v.codpessoa = :pessoa)
   AND  (:situacao = -99 or v.situacao = :situacao)
   AND  (:localdestino = -99 or v.localdestino = :localdestino)
   AND  (:localorigem = -99 or v.localorigem = :localorigem)
   AND  (:usuario = '(TODOS)' or v.usuarioreg = :usuario)
   AND  (:status = '(TODOS)' or v.status = :status)
   AND  (:datatramiteini = :datatramiteinidefault or exists (select t.entidade
                                                  from tramitacao t
                                                  where t.entidade = v.entidade
                                                      and t.ano = v.ano
                                                      and t.tipo = v.tipo
                                                      and t.numero = v.numero
                                                      and t.data between :datatramiteini and :datatramitefim))
   and ((:codcaixa = -99 and :anocaixa = -99) or exists (select t.entidade
                                                           from tramitacao t
                                                           where t.entidade = v.entidade
                                                              and t.ano = v.ano
                                                              and t.tipo = v.tipo
                                                              and t.numero = v.numero
                                                              and t.codcaixa = :codcaixa
                                                              and t.anocaixa = :anocaixa))
   AND (:complementoassunto = '(TODOS)' or LOWER(v.complementoassunto) LIKE :complementoAssuntoLike)
   AND ((:parecer = '(TODOS)') or exists (select t.entidade
                                                          from tramitacao t
                                                          where t.entidade = v.entidade
                                                            and t.ano = v.ano
                                                            and t.tipo = v.tipo
                                                            and t.numero = v.numero
                                                            and LOWER(t.parecer) LIKE :parecerLike))
