SELECT
	P.TIPO,
	P.ANO,
	P.NUMERO,
	P.DATAPROCESSO,
	P.HORAORIGEM,
	TO_CHAR(P.HORAORIGEM,'HH24:MI:SS') AS HORAORIGEMFORMATADA,
	PESS.NOME,
	TP.DESCRICAO AS TIPODESCRICAO,
	COALESCE(A.DESCRICAO,'NAO INFORMADO') AS ASSUNTODESCRICAO,
	A.CODIGO AS ASSUNTOCODIGO,
	LO.DESCRICAO ENDERECO,
	EP.NUMERO AS ENDNUMERO,
	BA.DESCRICAO AS ENDBAIRRO,
	P.DIGITACAO,
	P.TELEFONE,
	cast(L.CODIGO as varchar(50)) AS LOCALORIGEM,
	COALESCE(L.DESCRICAO,'NAO INFORMADO')AS LOCALORIGEMDESCRICAO,
	cast(LD.CODIGO as varchar(50)) AS LOCALDESTINO,
	COALESCE(LD.DESCRICAO,'NAO INFORMADO')AS LOCALDESTINODESCRICAO,
	P.SENHAINTERNET,
	EP.COMPLEMENTO AS ENDCOMPLEMENTO,
	EP.CEP AS ENDCEP,
	CI.UNIDADEFEDERACAO AS ENDUF,
	CI.DESCRICAO AS ENDCIDADE,
	A.COMPLEMENTO AS ASSUNTOCOMPLEMENTO,
	P.ASSUNTO PROCESSOCOMPLEMENTO,
	E.NOME AS DESCENTIDADE,
	CONCAT(CONCAT(CONCAT(CONCAT(P.ANO, '$'), P.TIPO), '$'), P.NUMERO) AS CODBARRA
FROM PROCESSOS P
INNER JOIN TIPOSPROTOCOLO TP
   ON P.TIPO = TP.CODIGO
INNER JOIN ENTIDADE E
   ON P.ENTIDADE = E.ENTIDADE
LEFT JOIN ASSUNTO A
   ON P.CODASSUNTO = A.CODIGO
LEFT JOIN LOCAIS L
  ON P.ENTIDADE = L.ENTIDADE
 AND P.LOCALATUAL = L.CODIGO
LEFT JOIN UNIDADEORCAMENTARIA U
  ON L.ENTIDADE = U.ENTIDADE
 AND L.UNIDADE = U.UNIDADE
LEFT JOIN UNIDADE O
  ON U.ENTIDADE = O.ENTIDADE
 AND U.ORGAO = O.CODIGO
LEFT JOIN SITUACOES S
  ON P.SITUACAO = S.CODIGO
LEFT JOIN COORDENADORIA C
  ON L.ENTIDADE = C.ENTIDADE
 AND L.COORDENADORIA = C.COORDENADORIA
LEFT JOIN DIRETORIA D
  ON L.ENTIDADE = D.ENTIDADE
 AND L.DIRETORIA = D.DIRETORIA
LEFT JOIN GERENCIA G
  ON L.ENTIDADE = G.ENTIDADE
 AND L.GERENCIA = G.GERENCIA
LEFT JOIN PESSOA PESS
  ON P.CODPESSOA = PESS.CODPESSOA
LEFT JOIN LOCAIS LD
  ON LD.ENTIDADE = P.ENTIDADE
 AND LD.CODIGO = P.LOCALDESTINO
LEFT JOIN ENDERECOPESSOA EP
  ON PESS.CODPESSOA = EP.CODPESSOA
 AND PESS.SEQUENCIAENDERECO = EP.SEQUENCIA
LEFT JOIN BAIRRO BA
  ON EP.CIDADE = BA.CIDADE
 AND EP.BAIRRO = BA.BAIRRO
LEFT JOIN CIDADE CI
  ON EP.CIDADE = CI.CIDADE
LEFT JOIN LOGRADOURO LO
  ON LO.LOGRADOURO = EP.LOGRADOURO
WHERE P.ENTIDADE = :entidade
  AND (P.TIPO = :tipo OR :tipo = -99)
  AND (P.ANO = :ano OR :ano = -99)
  AND (P.NUMERO BETWEEN :numeroini AND :numerofim OR :numeroini = -99)
  AND (P.DATAPROCESSO BETWEEN :dataprocessoini AND :dataprocessofim OR :dataprocessoini = :dataprocessoinidefault)
  AND (P.CODPESSOA = :pessoa OR :pessoa = -99)
