SELECT A.ANO AS EXERCICIO,
       EXTRACT(MONTH FROM A.DATAPROCESSO) as MES,
       COUNT(A.TIPO) AS PEDIDOS,
       SUM(CASE WHEN A.STATUS = 'A'
                 AND A.SITUACAO <> CAST(COALESCE(B.VALOR, '2') AS INTEGER)
                 AND A.SITUACAO <> CAST(COALESCE(C.VALOR, '2') AS INTEGER) THEN 1 ELSE 0 END) AS ATENDIDOS,
       SUM(CASE WHEN A.STATUS = 'A' AND A.SITUACAO = CAST(COALESCE(B.VALOR, '2') AS INTEGER) THEN 1 ELSE 0 END) AS CANCELADOS,
       SUM(CASE WHEN A.STATUS = 'A' AND A.SITUACAO = CAST(COALESCE(C.VALOR, '2') AS INTEGER) THEN 1 ELSE 0 END) AS INDEFERIDOS
  FROM PROCESSOS A
  LEFT OUTER JOIN PARAMETROS B
    ON B.ENTIDADE = A.ENTIDADE
   AND B.EXERCICIO = A.ANO
   AND B.CODIGO = 91
   AND (B.VALOR IS NOT NULL AND B.VALOR <> '')
  LEFT OUTER JOIN PARAMETROS C
    ON  C.ENTIDADE = A.ENTIDADE
   AND C.EXERCICIO = A.ANO
   AND C.CODIGO = 107
   AND (C.VALOR IS NOT NULL AND C.VALOR <> '')
 WHERE A.USUARIOREG = 'e-SIC'
