  SELECT COUNT(TB1."VALUE") AS "VALUE",
  TB1.LABEL
  FROM ( SELECT COUNT(A.NUMERO) AS "VALUE",
           CASE WHEN P.DATANASCIMENTO IS NULL THEN 'Não Informado'
                WHEN TRUNC(cast((cast(A.DATAPROCESSO as date) - cast(P.DATANASCIMENTO as date))/ 365.25 as decimal)) <= 20 THEN 'Até 20 anos'
                WHEN TRUNC(cast((cast(A.DATAPROCESSO as date) - cast(P.DATANASCIMENTO as date))/ 365.25 as decimal)) <= 30 THEN 'De 21 a 30 anos'
                WHEN TRUNC(cast((cast(A.DATAPROCESSO as date) - cast(P.DATANASCIMENTO as date))/ 365.25 as decimal)) <= 40 THEN 'De 31 a 40 anos'
                WHEN TRUNC(cast((cast(A.DATAPROCESSO as date) - cast(P.DATANASCIMENTO as date))/ 365.25 as decimal)) <= 50 THEN 'De 41 a 50 anos'
                WHEN TRUNC(cast((cast(A.DATAPROCESSO as date) - cast(P.DATANASCIMENTO as date))/ 365.25 as decimal)) <= 60 THEN 'De 51 a 60 anos'
                WHEN TRUNC(cast((cast(A.DATAPROCESSO as date) - cast(P.DATANASCIMENTO as date))/ 365.25 as decimal)) > 60 THEN 'Acima de 60 anos'
            END AS LABEL
  FROM PROCESSOS A
  LEFT JOIN PESSOA P ON
    A.CODPESSOA = P.CODPESSOA
 WHERE A.USUARIOREG = 'e-SIC'
 $[FILTRO]
 GROUP BY P.DATANASCIMENTO, A.DATAPROCESSO
) AS TB1
GROUP BY LABEL
