SELECT P.ANO,
	   P.NUMERO,
	   P.DATAORIGEM,
	   P.TIPO,
	   P.ENTIDADE,
	   S.NOME NOMEREQUERENTE,
	   P.DATAPROCESSO,
	   P.LOCALDESTINO,
       T.DESCRICAO AS DESCRTIPOLOGRADOURO,
       COALESCE(P.CEP, EC.CEP) AS CEP,
       COALESCE(P.ENDERECO, L.DESCRICAO) DESCLOGRADOURO,
       COALESCE(P.NUMEROENDERECO, EC.numero) as NUMEROENDERECO,
       COALESCE(P.BAIRROAUX, B.DESCRICAO) DESCBAIRRO,
       COALESCE(P.CIDADEAUX, C.DESCRICAO) DESCCIDADE,
       COALESCE(P.UF,  C.unidadefederacao) AS UNIDADEFEDERACAO,
       COALESCE(P.COMPLEMENTO, EC.complemento) as complementoendereco,
       S.TELEFONE,
       COALESCE(P.CELULAR, S.CELULAR) AS CELULAR,
       COALESCE(P.EMAIL, S.EMAIL) AS EMAIL,
       P.DIGITACAO,
       P.COMPLEMENTO,
       P.CODASSUNTO,
       P.ASSUNTO ASSUNTOPROC,
       S.CNPJ_CPF,
       S.RG,
       P.CODPESSOA,
       S.PESSOA,
       A.DESCRICAO DESCASSUNTO,
       P.HORAORIGEM,       
       P.OUTROSDADOS,
       L1.DESCRICAO AS DESCLOCALDESTINO,
       P.USUARIOREG,
       U.NOME AS NOMEUSUARIO,
       A.ASSUNTOINTERNO,
       CASE
       	WHEN
       		A.ASSUNTOINTERNO = 'S' THEN ' '
        ELSE
        	P.SENHAINTERNET
        END AS SENHAINTERNET,
       L2.DESCRICAO AS DESCLOCALORIGEM,
       SI.DESCRICAO AS SITUACAO,
       TR.PARECER AS RESULTADO
FROM PROCESSOS P
	INNER JOIN PESSOA S ON P.CODPESSOA = S.CODPESSOA
	LEFT JOIN ENDERECOPESSOA EC ON   EC.CODPESSOA = S.CODPESSOA
                               AND EC.SEQUENCIA = S.SEQUENCIAENDERECO  	
	LEFT JOIN ASSUNTO A ON P.CODASSUNTO = A.CODIGO
	LEFT JOIN LOGRADOURO L ON EC.LOGRADOURO = L.LOGRADOURO
	LEFT JOIN TIPOLOGRADOURO T ON T.TIPOLOGRADOURO = L.TIPOLOGRADOURO
	LEFT JOIN BAIRRO B ON EC.BAIRRO = B.BAIRRO
	LEFT JOIN CIDADE C ON EC.CIDADE = C.CIDADE
	LEFT JOIN LOCAIS L1 ON L1.ENTIDADE = P.ENTIDADE AND L1.CODIGO = P.LOCALDESTINO
	LEFT JOIN LOCAIS L2 ON L2.ENTIDADE = P.ENTIDADE AND L2.CODIGO = P.LOCALORIGEM
	LEFT JOIN USUARIO U ON U.LOGIN1 = P.USUARIOREG
	LEFT JOIN SITUACOES SI ON SI.CODIGO = P.SITUACAO
	LEFT JOIN TRAMITACAO TR ON TR.ENTIDADE = P.ENTIDADE AND TR.TIPO = P.TIPO AND TR.ANO = P.ANO AND TR.NUMERO = P.NUMERO
WHERE P.TIPO = ?
AND P.ANO = ?
AND P.NUMERO = ?
AND P.ENTIDADE = ?
AND TR.SEQUENCIA = ?
