SELECT a.data datatramite,
       b.dataprocesso,
       b.tipo,
       b.numero,
       b.ano,
       b.digitacao,
       b.outrosdados,
       c.nome requerente,
       d.descricao assunto,
       b.assunto compassunto,
       cast(CASE
                WHEN a.funcao = 'E' THEN 'Encaminhado'
                WHEN a.funcao = 'R' THEN 'Recebido'
                ELSE 'Em Trâmite'
            END AS varchar(11)) situcao,
       a.sequencia,
       a.local,
       cast((cast(f.codigo AS varchar(10))||' - '||f.descricao) AS varchar(300)) AS localdestino,

  (SELECT cast((cast(g.codigo AS varchar(10))||' - '||g.descricao) AS varchar(300))
   FROM locais g,
        tramitacao h
   WHERE h.entidade = a.entidade
     AND h.ano = a.ano
     AND h.numero = a.numero
     AND h.tipo = a.tipo
     AND h.sequencia = a.sequencia -1
     AND h.entidade = g.entidade
     AND h.local = g.codigo ) localorigem,
       a.parecer,
       a.hora,
       g.nome AS usuarioregistro,
       b.ano,
       b.entidade,
       b.tipo,
       a.lote,
       a.lotesequencia
FROM tramitacao a
INNER JOIN processos b ON b.entidade = a.entidade
AND b.ano = a.ano
AND b.numero = a.numero
AND b.tipo = a.tipo
INNER JOIN pessoa c ON c.codpessoa = b.codpessoa
INNER JOIN assunto d ON d.codigo = b.codassunto
INNER JOIN locais f ON f.entidade = a.entidade
AND f.codigo = a.local
INNER JOIN situacoes s ON s.codigo = b.situacao
LEFT JOIN usuario g ON g.login1 = a.usuarioreg
WHERE a.entidade = :entidade
  AND a.sequencia =
    (SELECT max(e.sequencia)
     FROM tramitacao e
     WHERE e.entidade = a.entidade
       AND e.ano = a.ano
       AND e.tipo = a.tipo
       AND e.numero = a.numero)
  AND (a.ano = :anoprocesso   OR :anoprocesso = -99)
  AND (a.tipo = :tipo         OR :tipo = -99)
  AND (a.numero >= :numinicioprocesso  OR :numinicioprocesso = -99)
  AND (a.numero <= :numfimprocesso     OR :numfimprocesso = -99)
  AND (b.dataprocesso >= :datainicioprocesso   OR :datainicioprocesso = :defaultdatainicio)
  AND (b.dataprocesso <= :datafimprocesso      OR :datafimprocesso = :defaultdatafim)
  AND (a.data >= :datainiciotramite  OR :datainiciotramite = :defaultdatainicio)
  AND (a.data <= :datafimtramite     OR :datafimtramite = :defaultdatafim)
  AND (a.hora >= :horainiciotramite  OR :horainiciotramite = :defaulthorainicio)
  AND (a.hora <= :horafimtramite     OR :horafimtramite = :defaulthorafim)
  AND (a.local IN (:localdestino)    OR :localdestino = -99)
  AND (a.lote IN (:lote) OR :lote = -99)
  AND (b.codassunto IN (:assunto) OR :assunto = -99)
  AND (a.situacao IN (:situacao) OR :situacao = -99)
  AND EXISTS
    (SELECT h.local
     FROM tramitacao h
     WHERE h.entidade = a.entidade
       AND h.ano = a.ano
       AND h.numero = a.numero
       AND h.tipo = a.tipo
       AND h.sequencia = a.sequencia -1
       AND (h.local IN (:localorigem)
            OR :localorigem = -99))
  AND (upper(a.usuarioreg) = :usuario OR :usuario = '(TODOS)')