SELECT P.TIPO,
       P.ANO,
       P.NUMERO,
       P.CODASSUNTO,
       P.LOCALDESTINO,
       P.DATAPROCESSO,
       P.USUARIOREG,
       P.DATAREG,
       P.ASSUNTO AS ASSUNTOPROC,
       P.CODPESSOA,
       P.OUTROSDADOS,

       P.COMPLEMENTO,
       P.BAIRRO CODBAIRRO,
       C.UNIDADEFEDERACAO,
       P.CIDADE CODCIDADE,

       P.MODALIDADELICITACAO,
       P.NUMEROLICITACAO,
       P.HORAORIGEM,
       P.BO_RECURSOPROPRIO,
       P.BO_RECURSOESTADUAL, 
       P.BO_RECURSOFEDERAL,
       P.DIGITACAO,
       S.NOME NOMEREQUERENTE,
       S.CNPJ_CPF,
       S.RG,
       S.PESSOA,
       S.TELEFONE,
       S.CELULAR,
       S.EMAIL,
       S.SEQUENCIACORRESPONDENCIA,
       A.DESCRICAO AS DESCASSUNTO,
       C.DESCRICAO AS DESCCIDAD,
       LOG.DESCRICAO AS DESCLOGRADOURO,
       TL2.DESCRICAO AS TIPOLOGRADOURO, 
       (SELECT L1.SIGLA FROM LOCAIS L1 WHERE L1.ENTIDADE = P.ENTIDADE AND L1.CODIGO = P.LOCALDESTINO )AS SIGLALOCALDESTINO, 
       (SELECT L2.DESCRICAO FROM LOCAIS L2 WHERE L2.ENTIDADE = P.ENTIDADE AND L2.CODIGO = P.LOCALDESTINO) AS DESCRLOCALDESTINO,
       (SELECT L3.SIGLA FROM LOCAIS L3 WHERE L3.ENTIDADE = P.ENTIDADE AND L3.CODIGO = P.LOCALORIGEM )AS SIGLALOCALORIGEM, 
       (SELECT L4.DESCRICAO FROM LOCAIS L4 WHERE L4.ENTIDADE = P.ENTIDADE AND L4.CODIGO = P.LOCALORIGEM) AS DESCRLOCALORIGEM, 
       CASE WHEN A.ASSUNTOINTERNO = 'S' THEN ' ' ELSE P.SENHAINTERNET END AS SENHAINTERNET,
       UN.DESCRICAO DESCUNIDADE,
       UN.UNIDADE,
       TP.DESCRICAO  AS DESCTIPOPROTOCOLO, 
       P.PROCESSO_REFERENCIA,
       A.MENSAGEM AS ASSUNTOMENSSAGEM,
       EC.NUMERO AS NUMEROENDERECOPESSOA,
       COALESCE(P.CEP, EC.CEP) AS CEP,
       COALESCE(P.NUMEROENDERECO, EC.NUMERO) AS NUMEROENDERECO,
       COALESCE(P.ENDERECO, LOG.DESCRICAO) AS DESCENDERECO,
       COALESCE(P.COMPLEMENTO, EC.COMPLEMENTO) AS COMPLEMENTOENDERECO,
       COALESCE(P.BAIRROAUX, BCO.DESCRICAO) AS DESCBAIRRO, COALESCE(P.CIDADEAUX, CCO.DESCRICAO) AS DESCCIDADE,
       COALESCE(P.UF, CCO.UNIDADEFEDERACAO) AS DESCUNIDADEFEDERACAO,
       COALESCE(CCO.DESCRICAO, P.CIDADEAUX) AS DESCCIDADEREQUERENTE,
       COALESCE(CCO.UNIDADEFEDERACAO, P.UF) AS UFREQUERENTE,
       COALESCE(BCO.DESCRICAO, P.BAIRROAUX) AS DESCBAIRROREQUERENTE,
       COALESCE(EC.COMPLEMENTO, P.COMPLEMENTO) AS COMPLEMENTOENDERECOREQUERENTE,
       COALESCE(EC.CEP, P.CEP) AS CEPREQUERENTE,
       P.ZONA,
       P.QUADRA,
       P.DATA AS LOTE,
       P.CADASTRO,
       U.NOME NOMEUSUARIOREG,
       P.OUVIDORIAANONIMA,
       CASE WHEN P.ENDERECO IS NULL OR P.ENDERECO = '' THEN 'N/A'
            ELSE P.ENDERECO
                 ||CONCAT(', ',P.NUMEROENDERECO)
                 ||CONCAT(', ',P.COMPLEMENTO)
                 ||CONCAT(' - ',P.BAIRROAUX)
                 ||CONCAT('. ',P.CIDADEAUX)
                 ||CONCAT(' - ',P.UF)
                 ||CONCAT(' CEP: ',P.CEP)
       END ENDERECOCOMPLEMENTAR
  FROM PROCESSOS P
  JOIN ASSUNTO A 
    ON P.CODASSUNTO = A.CODIGO
  JOIN PESSOA S 
    ON P.CODPESSOA = S.CODPESSOA
  LEFT JOIN CIDADE C 
    ON P.CIDADE = C.CIDADE
  LEFT JOIN BAIRRO B 
    ON P.BAIRRO = B.BAIRRO
  LEFT JOIN TIPOSPROTOCOLO TP 
    ON TP.CODIGO = P.TIPO
  LEFT JOIN LOCAIS L 
    ON L.CODIGO = P.LOCALORIGEM 
   AND L.ENTIDADE = P.ENTIDADE
  LEFT JOIN LOGRADOURO LG 
    ON P.LOGRADOURO = LG.LOGRADOURO
  LEFT JOIN TIPOLOGRADOURO TL 
    ON LG.TIPOLOGRADOURO = TL.TIPOLOGRADOURO
  LEFT JOIN UNIDADEORCAMENTARIA UN 
    ON P.ENTIDADE = UN.ENTIDADE
   AND UN.ORGAO = L.ORGAO 
   AND UN.UNIDADE = L.UNIDADE 
  LEFT JOIN ENDERECOPESSOA EC 
    ON EC.CODPESSOA = S.CODPESSOA
   AND EC.SEQUENCIA = S.SEQUENCIAENDERECO 
  LEFT JOIN LOGRADOURO LOG 
    ON LOG.LOGRADOURO = EC.LOGRADOURO
  LEFT JOIN TIPOLOGRADOURO TL2 
    ON LOG.TIPOLOGRADOURO = TL2.TIPOLOGRADOURO
  LEFT JOIN CIDADE CCO 
    ON CCO.CIDADE = LOG.CIDADE
  LEFT JOIN BAIRRO BCO  
    ON BCO.BAIRRO = EC.BAIRRO
  LEFT JOIN USUARIO U 
    ON U.LOGIN1 = P.USUARIOREG 
  LEFT JOIN TRAMITACAO T 
    ON T.TIPO = P.TIPO 
   AND T.ANO = P.ANO 
   AND T.NUMERO = P.NUMERO 
   AND P.ENTIDADE = T.ENTIDADE
 WHERE P.TIPO = ?
   AND P.ANO = ?
   AND P.NUMERO = ?
   AND P.ENTIDADE = ?
   AND (T.SEQUENCIA = (SELECT MAX(SEQUENCIA) 
                         FROM TRAMITACAO T2 
                        WHERE T2.TIPO = T.TIPO 
                          AND T2.ANO = T.ANO 
                          AND T2.NUMERO = T.NUMERO 
                          AND T2.ENTIDADE = T.ENTIDADE) OR T.SEQUENCIA IS NULL)