select pr
    from Processo pr
    left join pr.assunto a 
    left join a.roteiro rot 
where pr.id.entidade.id = :entidade
    and pr.id.ano >= :anoBase
    and year(pr.dataProcesso) >= :anoBase
    and pr.funcao in :funcoes
    and dateMinus(pr.previsaoConclusao, cast(:dataBase as LocalDate)) <= :quantidadeDias
    and dateMinus(pr.previsaoConclusao, cast(:dataBase as LocalDate)) >= 0
    and ((:acessoTotal = true) or exists( select 1 
                from Tramite tr 
                where tr.id.processo = pr
                and tr.local.id.id in (select usrLoc.id.local.id.id 
                                            from UsuarioLocal usrLoc  
                                            where usrLoc.id.usuario.id = :username
                                                and  usrLoc.id.local.id.entidade.id = :entidade)))
