CREATE OR REPLACE VIEW VW_PROCESSOS AS
SELECT P.ENTIDADE,
       E.NOME AS DESCENTIDADE,
       P.TIPO,
       TP.DESCRICAO AS TIPODESCRICAO,
       P.ANO,
       P.NUMERO,
       P.UNIDADE,
       PESS.NOME,
       P.CODASSUNTO,
       P.DATAORIGEM,
       P.HORAORIGEM,
       TO_CHAR(P.HORAORIGEM, 'HH24:MI:SS') AS HORAORIGEMFORMATADA,
       P.DATAPROCESSO,
       P.DATADESTINO,
       P.HORADESTINO,
       P.SITUACAO,
       P.STATUS,
       P.USUARIOREG,
       P.DATAREG,
       P.CODPESSOA,
       P.DIGITACAO,
       P.LOCALORIGEM,
       P.LOCALDESTINO,
       P.SENHAINTERNET,
       P.IMOVEL,
       P.ZONA,
       P.QUADRA,
       P.DATA,
       P.CADASTRO,
       L.GERENCIA,
       L.COORDENADORIA,
       L.DIRETORIA,
       A.CODIGO AS ASSUNTOCODIGO,
       COALESCE(A.DESCRICAO, 'NAO INFORMADO') AS ASSUNTODESCRICAO,
       COALESCE(L.DESCRICAO, 'NAO INFORMADO') AS LOCALDESCRICAO,
       COALESCE(U.DESCRICAO, 'NAO INFORMADO') AS UNIDADEDESCRICAO,
       COALESCE(O.DESCRICAO, 'NAO INFORMADO') AS ORGAODESCRICAO,
       COALESCE(G.DESCRICAO, 'NAO INFORMADO') AS GERENCIADESCRICAO,
       COALESCE(PESS.NOME, 'NAO INFORMADO') AS PESSOANOME,
       COALESCE(S.DESCRICAO, 'NAO INFORMADO') AS SITUACAODESCRICAO,
       COALESCE(LD.DESCRICAO, 'NAO INFORMADO') AS LOCALDESTINODESCRICAO,
       A.COMPLEMENTO AS ASSUNTOCOMPLEMENTO,
       EP.ENDERECO,
       EP.NUMERO AS ENDNUMERO,
       EP.COMPLEMENTO AS ENDCOMPLEMENTO,
       EP.UF AS ENDUF,
       EP.CEP AS ENDCEP,
       BA.DESCRICAO AS ENDBAIRRO,
       CI.DESCRICAO AS ENDCIDADE,
       P.TELEFONE,
       CASE P.STATUS
           WHEN 'A' THEN 'Arquivado'
           WHEN 'R' THEN 'Recebido'
           WHEN 'C' THEN 'Aberto'
           WHEN 'E' THEN 'Encaminhado'
           ELSE NULL
           END AS STATUSDESCRICAO,
       CONCAT(CONCAT(CONCAT(CONCAT(P.ANO, '$'), P.TIPO), '$'), P.NUMERO) AS CODBARRA,
       P.ASSUNTO AS COMPLEMENTOASSUNTO
FROM PROCESSOS P
         JOIN TIPOSPROTOCOLO TP ON P.TIPO = TP.CODIGO
         JOIN ENTIDADE E ON P.ENTIDADE = E.ENTIDADE
         LEFT JOIN ASSUNTO A ON P.CODASSUNTO = A.CODIGO
         LEFT JOIN LOCAIS L ON P.ENTIDADELOCALATUAL = L.ENTIDADE AND P.LOCALATUAL = L.CODIGO
         LEFT JOIN UNIDADEORCAMENTARIA U ON L.ENTIDADE = U.ENTIDADE AND L.UNIDADE = U.UNIDADE
         LEFT JOIN UNIDADE O ON U.ENTIDADE = O.ENTIDADE AND U.ORGAO = O.CODIGO
         LEFT JOIN SITUACOES S ON P.SITUACAO = S.CODIGO
         LEFT JOIN COORDENADORIA C ON L.ENTIDADE = C.ENTIDADE AND L.COORDENADORIA = C.COORDENADORIA
         LEFT JOIN DIRETORIA D ON L.ENTIDADE = D.ENTIDADE AND L.DIRETORIA = D.DIRETORIA
         LEFT JOIN GERENCIA G ON L.ENTIDADE = G.ENTIDADE AND L.GERENCIA = G.GERENCIA
         LEFT JOIN PESSOA PESS ON P.CODPESSOA = PESS.CODPESSOA
         LEFT JOIN LOCAIS LD ON LD.ENTIDADE = P.ENTIDADELOCALDESTINO AND LD.CODIGO = P.LOCALDESTINO
         LEFT JOIN ENDERECOPESSOA EP
                   ON PESS.CODPESSOA = EP.CODPESSOA AND PESS.SEQUENCIAENDERECO = EP.SEQUENCIA
         LEFT JOIN BAIRRO BA ON EP.CIDADE = BA.CIDADE AND EP.BAIRRO = BA.BAIRRO
         LEFT JOIN CIDADE CI ON EP.CIDADE = CI.CIDADE
