CREATE OR REPLACE VIEW controle_email AS
select he.id, 'PROCESSO' as tipoorigem, he.datacriacao, he.tipoenvio, he.destinatario,
       he.usuario, he.pessoa, he.assunto, he.entidade, he.dataleitura,
       he.numero || '/' || he.ano || ' Tipo: ' || tp.descricao as identificador
  from historicoprocessoemail he
 inner join tiposprotocolo tp on tp.codigo = he.tipo
 union all
select he.id, 'TRAMITE' as tipoorigem, he.datacriacao, he.tipoenvio, he.destinatario,
       he.usuario, he.pessoa, he.assunto, he.entidade, he.dataleitura,
 		t.numero || '/' || t.ano || ' Tipo: ' || tp.descricao || ' Local: ' || l.descricao || ' Data: ' || t.data as identificador
  from historicotramiteemail he
 inner join tramitacao t on t.entidade = he.entidade
                        and t.ano = he.ano
                        and t.tipo = he.tipo
                        and t.numero = he.numero
                        and t.sequencia = he.sequencia
 inner join tiposprotocolo tp on tp.codigo = he.tipo
 inner join locais l on t.entidade = l.entidade
                    and t.local = l.codigo
 union all
select he.id, 'ARQUIVO_PROCESSO' as tipoorigem, he.datacriacao, he.tipoenvio, he.destinatario,
       he.usuario, he.pessoa, he.assunto, he.entidade, he.dataleitura,
       pa.numero || '/' || pa.ano || ' Tipo: ' || tp.descricao || ' Arquivo: ' || pa.nome as identificador
  from historicoprocarqemail he
 inner join protocolo_arquivos pa on pa.entidade = he.entidade
                                 and pa.ano = he.ano
                                 and pa.tipo = he.tipo
                                 and pa.numero = he.numero
                                 and pa.sequencia = he.sequencia
 inner join tiposprotocolo tp on tp.codigo = he.tipo
 union all
select he.id, 'ARQUIVO_ASSINATURA' as tipoorigem, he.datacriacao, he.tipoenvio, he.destinatario,
       he.usuario, he.pessoa, he.assunto, aa.entidade, he.dataleitura,
       aa.numero || '/' || aa.ano || ' Tipo: ' || tp.descricao || ' Tipo Assinante: ' || aa.tipoassinante as identificador
  from histarqassinaturaemail he
 inner join arquivos_assinatura aa on aa.id = he.processoarquivoassinatura_id
 inner join tiposprotocolo tp on tp.codigo = aa.tipo
 union all
select he.id, 'ANDAMENTO_PROCESSO' as tipoorigem, he.datacriacao, he.tipoenvio, he.destinatario,
       he.usuario, he.pessoa, he.assunto, pa.entidade, he.dataleitura,
       pa.numero || '/' || pa.ano || ' Tipo: ' || tp.descricao || ' Nrº Andamento: ' || pa.numeroAndamento as identificador
  from histprocandamentoemail he
 inner join protocoloandamento pa on pa.id = he.processoandamento_id
 inner join tiposprotocolo tp on tp.codigo = pa.tipo
