CREATE OR REPLACE FUNCTION nextlotetramite(pEntidade numeric) RETURNS numeric AS
$BODY$
DECLARE
  vNextId integer;
  vLastId integer;
  vNameSequence character varying(50);
BEGIN
  vNameSequence := 'SEQ_LOTE_TRAMITE_' || cast(pEntidade as varchar(2));
  SELECT COALESCE(MAX(LOTE),1) INTO vLastId FROM TRAMITACAO WHERE ENTIDADE = pEntidade;
  EXECUTE format('CREATE SEQUENCE IF NOT EXISTS %s MINVALUE 1 INCREMENT 1 MAXVALUE 9223372036854775807 START %s cache 1;', vNameSequence, vLastId);

  SELECT nextval(vNameSequence) INTO vNextId;
  RETURN vNextId;
END $BODY$
LANGUAGE plpgsql VOLATILE
COST 100;
#
