create or replace function NEXTLOTETRAMITE(pEntidade numeric) return numeric is PRAGMA AUTONOMOUS_TRANSACTION;
  vNextId numeric;
  vLastId numeric;
  vExistsSequence numeric;
  vNameSequence varchar(50);
begin
  vNameSequence := 'SEQ_LOTE_TRAMITE_' || TO_CHAR(pEntidade);
  select COALESCE(max(LOTE),1) into vLastId from tramitacao where entidade = pEntidade;
  select coalesce(count(*),0) into vExistsSequence FROM user_sequences WHERE sequence_name = vNameSequence;
  if (vExistsSequence = 0) then
    EXECUTE IMMEDIATE 'CREATE SEQUENCE ' || vNameSequence || ' START WITH '||vLastId||' INCREMENT BY 1';
    COMMIT;
  end if;

  EXECUTE IMMEDIATE 'SELECT '||vNameSequence||'.NEXTVAL FROM DUAL' INTO vNextId;

  return vNextId;
end;
#
