
create table TRAMITACAO
(
  ENTIDADE   FLOAT not null,
  TIPO       FLOAT not null,
  ANO        FLOAT not null,
  NUMERO     FLOAT not null,
  SEQUENCIA  FLOAT not null,
  DATA       DATE,
  HORA       DATE,
  FUNCAO     VARCHAR(1) not null,
  SITUACAO   FLOAT not null,
  CAIXA      VARCHAR(25),
  APEDIDODE  VARCHAR(40),
  USUARIOREG VARCHAR(15),
  DATAREG    TIMESTAMP,
  NROFOLHAS  FLOAT,
  PARECER    VARCHAR(4000),
  LOCAL      FLOAT,
  SIGLA      VARCHAR(10),
  CODCAIXA   FLOAT,
  ANOCAIXA   FLOAT,
  LOTE       FLOAT
);

alter table TRAMITACAO add constraint PKTRAMITACAO primary key (TIPO, ANO, NUMERO, ENTIDADE, SEQUENCIA);

alter table TRAMITACAO
  add constraint FKLOCAL foreign key (LOCAL, ENTIDADE)
  references LOCAIS (CODIGO, ENTIDADE);
  
alter table TRAMITACAO
  add constraint FKTRAMITACAO_ENTIDADE foreign key (ENTIDADE)
  references ENTIDADE (ENTIDADE);
 
create index FOREIGNPROCESSOS on TRAMITACAO (TIPO, ANO, NUMERO, ENTIDADE);

create index IDXANONUMEROTRAMITE on TRAMITACAO (ANO, NUMERO);
  
create index IDXLOCALTRAMITE on TRAMITACAO (LOCAL, ENTIDADE);

create index IDXTRAMITACAOUSUARIO on TRAMITACAO (USUARIOREG);