
create table TRAMITACAO
(
  ENTIDADE   BIGINT not null,
  TIPO       BIGINT not null,
  ANO        BIGINT not null,
  NUMERO     BIGINT not null,
  SEQUENCIA  BIGINT not null,
  DATA       DATE,
  HORA       TIME,
  FUNCAO     VARCHAR(1) not null,
  SITUACAO   BIGINT not null,
  CAIXA      VARCHAR(25),
  APEDIDODE  VARCHAR(40),
  USUARIOREG VARCHAR(15),
  DATAREG    TIMESTAMP,
  NROFOLHAS  BIGINT,
  PARECER    VARCHAR(4000),
  LOCAL      BIGINT,
  SIGLA      VARCHAR(10),
  CODCAIXA   BIGINT,
  ANOCAIXA   BIGINT,
  LOTE       BIGINT
);

alter table TRAMITACAO add constraint PKTRAMITACAO primary key (TIPO, ANO, NUMERO, ENTIDADE, SEQUENCIA);

alter table TRAMITACAO
  add constraint FKLOCAL foreign key (LOCAL, ENTIDADE)
  references LOCAIS (CODIGO, ENTIDADE);
  
alter table TRAMITACAO
  add constraint FKTRAMITACAO_ENTIDADE foreign key (ENTIDADE)
  references ENTIDADE (ENTIDADE);
 
create index FOREIGNPROCESSOS on TRAMITACAO (TIPO, ANO, NUMERO, ENTIDADE);

create index IDXANONUMEROTRAMITE on TRAMITACAO (ANO, NUMERO);
  
create index IDXLOCALTRAMITE on TRAMITACAO (LOCAL, ENTIDADE);

create index IDXTRAMITACAOUSUARIO on TRAMITACAO (USUARIOREG);