CREATE TABLE PROCESSOS
(
  TIPO                 FLOAT NOT NULL,
  ANO                  FLOAT NOT NULL,
  NUMERO               FLOAT NOT NULL,
  UNIDADE              FLOAT,
  NOME                 VARCHAR(80),
  ENDERECO             VARCHAR(100),
  COMPLEMENTO          VARCHAR(50),
  UF                   VARCHAR(2),
  CEP                  VARCHAR(9),
  TELEFONE             VARCHAR(40),
  CODASSUNTO           FLOAT,
  ASSUNTO              VARCHAR(40),
  DATAORIGEM           DATE,
  HORAORIGEM           DATE,
  DATAPROCESSO         DATE,
  DATADESTINO          DATE,
  HORADESTINO          DATE,
  SITUACAO             FLOAT,
  LOCAIS               VARCHAR(6),
  RG                   VARCHAR(20),
  OUTROSDADOS          VARCHAR(4000),
  PESSOA               VARCHAR(1),
  ENDIMOVEL            VARCHAR(80),
  INSCRIMOVEL          VARCHAR(40),
  STATUS               VARCHAR(1),
  EXIGENCIA            VARCHAR(1),
  MOTIVOEXIGENCIA      VARCHAR(255),
  USUARIOREG           VARCHAR(15),
  DATAREG              TIMESTAMP,
  CODPESSOA            FLOAT,
  EMAIL                VARCHAR(60),
  CELULAR              VARCHAR(60),
  DIGITACAO            VARCHAR(4000),
  LOCALORIGEMAUX       FLOAT,
  LOCALORIGEM          FLOAT,
  LOCALDESTINO         FLOAT,
  SENHAINTERNET        VARCHAR(5),
  SIGLAORIGEM          VARCHAR(10),
  SIGLADESTINO         VARCHAR(10),
  IMOVEL               FLOAT,
  ZONA                 VARCHAR(30),
  QUADRA               VARCHAR(30),
  DATA                 VARCHAR(30),
  CADASTRO             VARCHAR(30),
  ENTIDADE             FLOAT NOT NULL,
  CNPJ_CPF             VARCHAR(20),
  MODALIDADELICITACAO  VARCHAR(30),
  NUMEROLICITACAO      FLOAT,
  EXERCICIOLICITACAO   FLOAT,
  BAIRROAUX            VARCHAR(40),
  CIDADEAUX            VARCHAR(40),
  USUARIOALT           VARCHAR(15),
  LOGRADOURO           FLOAT,
  UNIDADEFEDERACAO     VARCHAR(2),
  TIPOENDERECO         VARCHAR(1),
  NUMEROENDERECO       VARCHAR(10),
  ORIGEM               FLOAT,
  BAIRRO               FLOAT,
  CIDADE               FLOAT,
  ABERTOCIDADAO        VARCHAR(1),
  TELACADASTRO         FLOAT,
  ENDCORRESPONDENCIA   FLOAT,
  STATUSNOVO           CHAR(1),
  PROCESSO_REFERENCIA  VARCHAR(50),
  BO_RECURSOPROPRIO    VARCHAR(1),
  BO_RECURSOESTADUAL   VARCHAR(1),
  BO_RECURSOFEDERAL    VARCHAR(1),
  LOCALATUAL           FLOAT,
  MOTIVOEDICAO         VARCHAR(2000),
  CODAUX               FLOAT,
  DATAENVIOEMAIL       DATE,
  IDAUTOINFRACAOFISCAL FLOAT,
  TIPOCADASTRO         FLOAT,
  FLAGMARCACAOPROJETO  CHAR(1),
  ENGARQSEPLAN         FLOAT,
  CODSECRETARIA        FLOAT
);

ALTER TABLE PROCESSOS
  ADD CONSTRAINT PKPROCESSOS PRIMARY KEY (TIPO, ANO, NUMERO, ENTIDADE);
  
ALTER TABLE PROCESSOS
  ADD CONSTRAINT FK_PROC_END_CORRESP FOREIGN KEY (ENDCORRESPONDENCIA)
  REFERENCES LOGRADOURO (LOGRADOURO);
  
ALTER TABLE PROCESSOS
  ADD CONSTRAINT FKPROCESSOS_BAIRRO FOREIGN KEY (BAIRRO, CIDADE)
  REFERENCES BAIRRO (BAIRRO, CIDADE);
  
ALTER TABLE PROCESSOS
  ADD CONSTRAINT FKPROCESSOS_CIDADE FOREIGN KEY (CIDADE)
  REFERENCES CIDADE (CIDADE);
  
ALTER TABLE PROCESSOS
  ADD CONSTRAINT FKPROCESSOS_ENTIDADE FOREIGN KEY (ENTIDADE)
  REFERENCES ENTIDADE (ENTIDADE);
  
ALTER TABLE PROCESSOS
  ADD CONSTRAINT FKPROCESSOS_LOGRADOURO FOREIGN KEY (LOGRADOURO)
  REFERENCES LOGRADOURO (LOGRADOURO);
  
ALTER TABLE PROCESSOS
  ADD CONSTRAINT FKPROCESSOS_ORIGEM FOREIGN KEY (ORIGEM, ENTIDADE)
  REFERENCES ORIGEM (ORIGEM, ENTIDADE) ON DELETE CASCADE;
  
ALTER TABLE PROCESSOS
  ADD CONSTRAINT FKPROCESSOS_UF FOREIGN KEY (UNIDADEFEDERACAO)
  REFERENCES UNIDADEFEDERACAO (UNIDADEFEDERACAO);
  
ALTER TABLE PROCESSOS
  ADD CONSTRAINT FOREIGNASSUNTOS FOREIGN KEY (CODASSUNTO)
  REFERENCES ASSUNTO (CODIGO);
  
ALTER TABLE PROCESSOS
  ADD CONSTRAINT FOREIGNSITUACAO FOREIGN KEY (SITUACAO)
  REFERENCES SITUACOES (CODIGO);
  
ALTER TABLE PROCESSOS
  ADD CONSTRAINT FOREIGNTIPOS FOREIGN KEY (TIPO)
  REFERENCES TIPOSPROTOCOLO (CODIGO);
  
alter table PROCESSOS
  add constraint FKLOCALORIGEM foreign key (ENTIDADE, LOCALORIGEM)
  references LOCAIS (ENTIDADE, CODIGO);  
 
alter table PROCESSOS
  add constraint FKLOCALDESTINO foreign key (ENTIDADE, LOCALDESTINO)
  references LOCAIS (ENTIDADE, CODIGO);  
  
CREATE INDEX IDXANONUMERO1 ON PROCESSOS (ANO, NUMERO);

CREATE INDEX IDX_ASSUNTO ON PROCESSOS (CODASSUNTO);

CREATE INDEX IDXCNPJ_CPFPROCESSOS ON PROCESSOS (CNPJ_CPF);

CREATE INDEX IDXCODPESSOAPROCESSO ON PROCESSOS (CODPESSOA);

CREATE INDEX IDX_ENTIDADETIPO ON PROCESSOS (ENTIDADE, TIPO, NUMERO);

CREATE INDEX IDXPROCESSODTORIGEM ON PROCESSOS (DATAORIGEM);

CREATE INDEX IDX_PROCRECEBIMENTO ON PROCESSOS (ENTIDADE, ANO, DATAPROCESSO, STATUS);