CREATE TABLE MODULO (
  MODULO VARCHAR(2) NOT NULL, 
  DESCRICAO VARCHAR(30), 
  PATH VARCHAR(100), 
  BASEDADOS VARCHAR(100), 
  VERSAOBASE VARCHAR(30), 
  VERSAOBASE_AUX VARCHAR(30), 
  BLOCKUPDATE VARCHAR(80), 
  BLOCKUPDATEKEY VARCHAR(120),
  IDUNICO NUMBER(10),
  CONSTRAINT PKMODULO PRIMARY KEY(MODULO)
);

CREATE TABLE TIPOLOGRADOURO
(
  TIPOLOGRADOURO NUMBER(10) NOT NULL,
  DESCRICAO      VARCHAR2(60),
  CONSTRAINT PKTIPOLOG PRIMARY KEY (TIPOLOGRADOURO)
);  


CREATE TABLE UNIDADEFEDERACAO
(
  UNIDADEFEDERACAO CHAR(2) NOT NULL,
  DESCRICAO        VARCHAR(50),
  CONSTRAINT PKUNIDADEFEDERACAO PRIMARY KEY (UNIDADEFEDERACAO)
);  

CREATE TABLE CIDADE (
  CIDADE NUMERIC(10,0) NOT NULL, 
  UNIDADEFEDERACAO CHAR(2) NOT NULL, 
  DESCRICAO VARCHAR(50), 
  BO_ATIVO VARCHAR(1), 
  ID_CIDADEAISE NUMERIC(10,0), 
  CONSTRAINT PKCIDADE PRIMARY KEY(CIDADE),
  CONSTRAINT FKUF_CIDADE FOREIGN KEY (UNIDADEFEDERACAO)
    REFERENCES UNIDADEFEDERACAO(UNIDADEFEDERACAO)
  
);

CREATE TABLE BAIRRO
(  
    CIDADE NUMERIC(10) NOT NULL, 
	BAIRRO NUMERIC(10) NOT NULL, 
	DESCRICAO VARCHAR(100), 
	BO_ATIVO VARCHAR(1),                         
    ID_BAIRROAISE NUMERIC(10),  
	CONSTRAINT PKBAIRRO PRIMARY KEY (CIDADE, BAIRRO),
	CONSTRAINT FKCIDADE_BAIRRO FOREIGN KEY (CIDADE) REFERENCES CIDADE (CIDADE)
);

CREATE TABLE LOGRADOURO (
  LOGRADOURO NUMERIC(10) NOT NULL,
  BAIRRO NUMERIC(10) NOT NULL, 
  CIDADE NUMERIC(10) NOT NULL, 
  TIPOLOGRADOURO NUMERIC(10) NOT NULL,
  CEP VARCHAR(10), 
  DESCRICAO VARCHAR(100), 
  BO_ATIVO VARCHAR(1), 
  ID_LOGRADOUROAISE NUMERIC(10),
  CONSTRAINT PKLOGRADOURO PRIMARY KEY(LOGRADOURO), 
  CONSTRAINT FKCIDADE FOREIGN KEY (CIDADE)
    REFERENCES CIDADE(CIDADE)
);

CREATE TABLE PESSOA (
  CODPESSOA NUMERIC(10) NOT NULL, 
  NOME VARCHAR(150), 
  TELEFONE VARCHAR(40), 
  RG VARCHAR(20), 
  PESSOA VARCHAR(1), 
  ENDIMOVEL VARCHAR(80), 
  INSCRIMOVEL VARCHAR(40), 
  EMAIL VARCHAR(60), 
  CELULAR VARCHAR(60), 
  SEQUENCIAENDERECO NUMERIC(10), 
  CNPJ_CPF VARCHAR(20), 
  SEQUENCIACORRESPONDENCIA NUMERIC(10), 
  CARGO VARCHAR(50), 
  ATIVO VARCHAR(1),
  IDUNICO NUMERIC(10),
  CONSTRAINT PESSOA_PKEY PRIMARY KEY(CODPESSOA)
);

CREATE TABLE ENDERECOPESSOA (
  CODPESSOA NUMERIC(10) NOT NULL, 
  SEQUENCIA NUMERIC(10) NOT NULL, 
  TIPOENDERECO VARCHAR(1), 
  ENDERECO VARCHAR(100), 
  NUMERO VARCHAR(10), 
  COMPLEMENTO VARCHAR(50), 
  UF CHAR(2), 
  CEP VARCHAR(10), 
  BAIRROAUX VARCHAR(50), 
  CIDADEAUX VARCHAR(50), 
  LOGRADOURO NUMERIC(10), 
  UNIDADEFEDERACAO CHAR(2), 
  BAIRRO NUMERIC(10), 
  CIDADE NUMERIC(10), 
  CONSTRAINT ENDERECOPESSOA_PKEY PRIMARY KEY(CODPESSOA, SEQUENCIA),
  CONSTRAINT FKENDPESSOA_BAIRRO FOREIGN KEY (CIDADE, BAIRRO)
	REFERENCES BAIRRO(CIDADE, BAIRRO), 
  CONSTRAINT FKENDPESSOA_CIDADE FOREIGN KEY (CIDADE)
	REFERENCES CIDADE (CIDADE), 
  CONSTRAINT FKENDPESSOA_LOGRADOURO FOREIGN KEY (LOGRADOURO)
	REFERENCES LOGRADOURO (LOGRADOURO), 
  CONSTRAINT FKENDPESSOA_UF FOREIGN KEY (UNIDADEFEDERACAO)
	REFERENCES UNIDADEFEDERACAO (UNIDADEFEDERACAO), 
  CONSTRAINT FKENDPESSOA_PESSOA FOREIGN KEY (CODPESSOA)
    REFERENCES PESSOA (CODPESSOA) 
);

CREATE TABLE ENTIDADE
(
   ENTIDADE           DOUBLE PRECISION NOT NULL,
   NOME               VARCHAR(60),
   CNPJ               VARCHAR(15),
   UF                 VARCHAR(2),
   CEP                VARCHAR(8),
   ENTIDADEPRINCIPAL  DOUBLE PRECISION,
   TIPOENTIDADE       VARCHAR(1),
   IDENTIFICACAOTCE   VARCHAR(10),
   BRASAO             BLOB,
   ENTIDADEORCAMENTO  DOUBLE PRECISION,
   TELEFONE           VARCHAR(20),
   BAIRROAUX          VARCHAR(50),
   CIDADEAUX          VARCHAR(50),
   LOGRADOUROAUX      VARCHAR(50),
   UNIDADEFEDERACAO   CHAR(2) NOT NULL,
   NUMERO             VARCHAR(10),
   LOGRADOURO         DOUBLE PRECISION NOT NULL,
   BAIRRO             DOUBLE PRECISION NOT NULL,
   CIDADE             DOUBLE PRECISION NOT NULL,
   CLIENTEELOTECHSN   CHAR(1) DEFAULT 'N',
   CONSTRAINT PKENTIDADE PRIMARY KEY (ENTIDADE),
   CONSTRAINT FKENDENTIDADE_BAIRRO FOREIGN KEY (CIDADE,BAIRRO) REFERENCES BAIRRO (CIDADE,BAIRRO),
   CONSTRAINT FKENDENTIDADE_CIDADE FOREIGN KEY (CIDADE) REFERENCES CIDADE (CIDADE),
   CONSTRAINT FKENDENTIDADE_LOGRADOURO FOREIGN KEY (LOGRADOURO) REFERENCES LOGRADOURO (LOGRADOURO),
   CONSTRAINT FKENDENTIDADE_UF FOREIGN KEY (UNIDADEFEDERACAO) REFERENCES UNIDADEFEDERACAO (UNIDADEFEDERACAO)
);

CREATE TABLE USUARIO (
  LOGIN1 VARCHAR(15) NOT NULL, 
  NOME VARCHAR(50), 
  SENHA VARCHAR(15), 
  LOCAL DOUBLE PRECISION, 
  VISUALIZA VARCHAR(1), 
  NIVELTRAMITE VARCHAR(1), 
  NIVELACESSO DOUBLE PRECISION, 
  NOMEPROG VARCHAR(60), 
  USUARIO DOUBLE PRECISION, 
  PADRAO VARCHAR(1), 
  VERIFICAMENSAGENS VARCHAR(1), 
  TEMPOVERIFICACAO DOUBLE PRECISION, 
  ATIVO VARCHAR(1), 
  ALTERATODOSPROC VARCHAR(1) DEFAULT 'N', 
  EMAIL VARCHAR(60), 
  BO_ANEXARARQUIVO VARCHAR(1),
  CPF VARCHAR(20),
  IMPRIMEPAPELETA CHAR(1),
  IDUNICO NUMBER(10),
  CONSTRAINT USUARIO_PKEY PRIMARY KEY(LOGIN1)
);


CREATE TABLE USRXMOD
(
   MODULO       VARCHAR(2)     NOT NULL,
   USUARIO      VARCHAR(15)    NOT NULL,
   PRIORITARIO  VARCHAR(1),
   NOVIDADES    VARCHAR(10),
   CONSTRAINT PK_USRXMOD PRIMARY KEY (MODULO, USUARIO),
   CONSTRAINT FK_USUARIOMOD_MODULO FOREIGN KEY (MODULO)
    REFERENCES MODULO(MODULO),
   CONSTRAINT FK_USUARIOMOD_USUARIO FOREIGN KEY (USUARIO)
    REFERENCES USUARIO(LOGIN1) 
);


CREATE TABLE USUARIO_ENTIDADE
(
   USUARIO   VARCHAR(15)    NOT NULL,
   ENTIDADE  FLOAT         NOT NULL,
   PADRAO    VARCHAR(1),
   CONSTRAINT PKUSUARIO_ENTIDADE PRIMARY KEY (USUARIO, ENTIDADE),
   CONSTRAINT FK_USUARIOENT_ENTIDADE FOREIGN KEY (ENTIDADE)
    REFERENCES ENTIDADE(ENTIDADE),
   CONSTRAINT FK_USUARIOENT_USUARIO FOREIGN KEY (USUARIO)
    REFERENCES USUARIO(LOGIN1) 
);

CREATE TABLE SELETOR (
	NOMEPROG VARCHAR2(20) NOT NULL,
	DESCRICAO VARCHAR2(60),
	NIVEL FLOAT,
	ORDEM FLOAT,	
	CONSTRAINT SYS_C0017985 PRIMARY KEY (NOMEPROG)
);

CREATE TABLE USUARIOSELETOR 
(
   MODULO VARCHAR2(2) NOT NULL, 
   SELETOR VARCHAR2(50) NOT NULL, 
   USUARIO VARCHAR2(15) NOT NULL, 
   AUTOGRAVA VARCHAR2(1), 
   REAPROVEITA VARCHAR2(1), 
   ACESSO FLOAT, 
   FAVORITO VARCHAR2(1), 
   ULTIMOREGISTRO VARCHAR2(245), 
   AUTOINSERI VARCHAR2(1), 
   INSERIR VARCHAR2(1), 
   ALTERAR VARCHAR2(1), 
   EXCLUIR VARCHAR2(1), 
   FUNCAOESPECIAL VARCHAR2(1), 
   PESQUISAVAZIA VARCHAR2(1), 
   PRIMARY KEY (MODULO, SELETOR, USUARIO)
);