/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest.assinatura;

import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.protocolo.converter.AssinaturaInfoDTOConverter;
import br.com.elotech.protocolo.domain.ProcessoArquivoAssinatura;
import br.com.elotech.protocolo.dto.AssinaturaInfoDTO;
import br.com.elotech.protocolo.service.assinatura.AssinaturaSearchService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/arquivos-assinaturas"})
public class AssinaturaSearchResource
extends ReadOnlyResource<ProcessoArquivoAssinatura, Long> {
    private final AssinaturaInfoDTOConverter converter = new AssinaturaInfoDTOConverter();

    @GetMapping(value={"/app"})
    public ResponseEntity<Page<AssinaturaInfoDTO>> findAllApp(@RequestParam(value="search", required=false, defaultValue="") String search, Pageable pageable) {
        Page assinaturasPendentes = this.getService().findByRsql(search, pageable);
        PageImpl result = new PageImpl(assinaturasPendentes.stream().map(arg_0 -> ((AssinaturaInfoDTOConverter)this.converter).to(arg_0)).collect(Collectors.toList()));
        return ResponseEntity.ok((Object)result);
    }

    @GetMapping(value={"/pendentes/{usuario}"})
    public ResponseEntity<Page<AssinaturaInfoDTO>> findAssinaturasPendentesUsuario(@PathVariable(value="usuario") String usuario) {
        List assinaturasPendentes = ((AssinaturaSearchService)this.getService()).findAssinaturasPendentesUsuario(usuario);
        PageImpl result = new PageImpl(assinaturasPendentes.stream().map(arg_0 -> ((AssinaturaInfoDTOConverter)this.converter).to(arg_0)).collect(Collectors.toList()));
        return ResponseEntity.ok((Object)result);
    }
}

