/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest.assinatura;

import br.com.elotech.protocolo.converter.ProcessoArquivoAssinaturaDTOConverter;
import br.com.elotech.protocolo.dto.AssinaturaDTO;
import br.com.elotech.protocolo.dto.AssinaturaDigitalFinalizadaDTO;
import br.com.elotech.protocolo.dto.AssinaturaLoteDTO;
import br.com.elotech.protocolo.dto.LoteProcessamentoAssinaturaDTO;
import br.com.elotech.protocolo.dto.ProcessoArquivoAssinaturaDTO;
import br.com.elotech.protocolo.dto.RejeitarAssinaturaLoteDTO;
import br.com.elotech.protocolo.exception.AssinadorDigitalException;
import br.com.elotech.protocolo.exception.PDFPrecisaPosicionar;
import br.com.elotech.protocolo.service.assinatura.AssinaturaLoteService;
import br.com.elotech.protocolo.service.assinatura.AssinaturaService;
import br.com.elotech.protocolo.service.assinatura.AssinaturaSolicitaService;
import com.google.zxing.WriterException;
import java.io.IOException;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/arquivos-assinaturas"})
public class AssinaturaResource {
    private final AssinaturaService assinaturaService;
    private final AssinaturaLoteService processoArquivoAssinaturaLoteService;
    private final AssinaturaSolicitaService assinaturaSolicitaService;

    public AssinaturaResource(AssinaturaService assinaturaService, AssinaturaLoteService processoArquivoAssinaturaLoteService, AssinaturaSolicitaService assinaturaSolicitaService) {
        this.assinaturaService = assinaturaService;
        this.processoArquivoAssinaturaLoteService = processoArquivoAssinaturaLoteService;
        this.assinaturaSolicitaService = assinaturaSolicitaService;
    }

    @PostMapping(value={"/assinar"})
    public ResponseEntity<Void> assinar(@RequestBody AssinaturaDTO assinaturaDTO) throws IOException, WriterException {
        try {
            this.assinaturaService.assinarIndividual(assinaturaDTO);
        }
        catch (PDFPrecisaPosicionar e) {
            this.assinaturaService.setObrigaPosicionamentoAssinatura(assinaturaDTO.getIdentificador());
            throw new AssinadorDigitalException(e.getMessage(), (Exception)((Object)e));
        }
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/assinar-lote"})
    public ResponseEntity<String> assinarLote(@RequestBody AssinaturaLoteDTO assinaturaLoteDTO) {
        return ResponseEntity.ok((Object)this.processoArquivoAssinaturaLoteService.criarProcessamentoEmLote(assinaturaLoteDTO));
    }

    @PostMapping(value={"/assinar-lote/proximo"})
    public ResponseEntity<Boolean> assinarLoteProximo(@RequestBody LoteProcessamentoAssinaturaDTO loteProcessamentoAssinaturaDTO) {
        return ResponseEntity.ok((Object)this.processoArquivoAssinaturaLoteService.assinarLoteProximo(loteProcessamentoAssinaturaDTO));
    }

    @PostMapping(value={"/assinar-digitalmente"})
    public ResponseEntity<Void> assinar(@RequestBody AssinaturaDigitalFinalizadaDTO assinaturaDigitalFinalizadaDTO) {
        this.assinaturaService.assinarArquivosDigitalmente(assinaturaDigitalFinalizadaDTO);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/quantidade-assinar-lote"})
    public ResponseEntity<Long> getQuantidadeAssinarLote(@RequestParam(name="rsql", defaultValue="", required=false) String rsql) {
        return ResponseEntity.ok((Object)this.processoArquivoAssinaturaLoteService.getQuantidadeAssinarLote(rsql));
    }

    @DeleteMapping(value={"/{identificador}/remover-pendentes"})
    public ResponseEntity<Void> removerPendentes(@PathVariable(value="identificador") String identificador) {
        this.assinaturaService.removerPendentes(identificador);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> removerAssinatura(@PathVariable(value="id") Long id) {
        this.assinaturaService.removerAssinatura(id);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/{id}/cancelar"})
    public ResponseEntity<Void> cancelarAssinatura(@PathVariable(value="id") Long id) {
        this.assinaturaService.cancelarAssinatura(id);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{identificador}/rejeitar-assinatura"})
    public ResponseEntity<Void> rejeitarAssinaturaDigital(@PathVariable(name="identificador") String identificador, @RequestBody String motivo) {
        this.assinaturaService.rejeitarAssinatura(identificador, motivo);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{identificador}/solicitar"})
    public ResponseEntity<Void> solicitarAssinatura(@PathVariable(name="identificador") String identificador, @RequestBody List<String> solicitacoes) {
        String usuarioSolicitanteId = SecurityContextHolder.getContext().getAuthentication().getName();
        this.assinaturaSolicitaService.solicitarAssinatura(identificador, solicitacoes, usuarioSolicitanteId);
        solicitacoes.forEach(arg_0 -> ((AssinaturaSolicitaService)this.assinaturaSolicitaService).enviaNotificacao(arg_0));
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{identificador}/solicitar-assinatura-digital"})
    public ResponseEntity<ProcessoArquivoAssinaturaDTO> solicitarAssinatura(@PathVariable(name="identificador") String identificador) {
        return ResponseEntity.ok((Object)new ProcessoArquivoAssinaturaDTOConverter().to(this.assinaturaSolicitaService.solicitarAssinaturaDigital(identificador)));
    }

    @PostMapping(value={"/rejeitar-assinatura-lote"})
    public ResponseEntity<String> rejeitarLote(@RequestBody RejeitarAssinaturaLoteDTO rejeitarAssinaturaLoteDTO) {
        this.assinaturaService.rejeitarAssinaturasEmLote(rejeitarAssinaturaLoteDTO);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{identificador}/utiliza-assinatura-posicional"})
    public ResponseEntity<Boolean> utilizaAssinaturaPosicional(@PathVariable(value="identificador") String identificador) {
        return ResponseEntity.ok((Object)this.assinaturaService.utilizaAssinaturaPosicional(identificador));
    }
}

