/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.adm.rsql.RsqlSpecification;
import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.protocolo.converter.UsuarioDTOConverter;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.UsuarioDTO;
import br.com.elotech.protocolo.dto.UsuarioEntidadeAtualDTO;
import br.com.elotech.protocolo.dto.UsuarioPermissaoLocalDTO;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.UsuarioService;
import br.com.elotech.protocolo.specs.UsuarioSpecificationHelper;
import br.com.elotech.protocolo.utils.UsuarioUtils;
import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/usuarios"})
public class UsuarioResource
extends BaseResourceDTO<Usuario, String, UsuarioDTO> {
    private final ParametroService parametroService;
    private final UsuarioService usuarioService;
    private final EntidadeService entidadeService;
    private final EntityManager entityManager;

    @GetMapping(value={"/{id}"})
    public ResponseEntity<UsuarioDTO> findOne(@PathVariable String id) {
        return super.findOne((Serializable)((Object)id));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<UsuarioDTO> update(@RequestBody @Valid UsuarioDTO dto, @PathVariable String id, Authentication authentication) {
        return super.update((Object)dto, (Serializable)((Object)id), authentication);
    }

    @RequestMapping(value={"/dto"}, method={RequestMethod.GET})
    public ResponseEntity<Page<UsuarioDTO>> findAllDTO(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page usuariosPage = this.usuarioService.findByRsql(search, pageable);
        Boolean isMaskUser = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_USUARIO_COM_MASCARA_COM_CPF_LGPD.getCodigo());
        Boolean isMaskCPF = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CPF_LGPD.getCodigo());
        Boolean isMaskCNPJ = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CNPJ_LGPD.getCodigo());
        return ResponseEntity.ok((Object)usuariosPage.map(usuario -> new UsuarioDTOConverter().to(usuario, isMaskUser, isMaskCPF, isMaskCNPJ)));
    }

    @GetMapping(value={"/nome/{id}"})
    public String findUserNameById(@PathVariable String id) {
        return this.usuarioService.findUserNameById(id);
    }

    @GetMapping(value={"/{id}/isUsuarioAdministrador"})
    public ResponseEntity<Boolean> isUsuarioAdministrador(@PathVariable String id) {
        return ResponseEntity.ok((Object)this.usuarioService.isUsuarioAdministrador(id, this.entidadeService.getEntidadeLogada()));
    }

    @GetMapping(value={"/entidadeAtual"})
    public ResponseEntity<Page<UsuarioEntidadeAtualDTO>> findAllEntidadeAtual(@RequestParam(value="search", required=false) String search, @RequestParam(value="isAdm", required=false) Boolean isAdm, Pageable pageable) {
        Long entidadeLogada = this.entidadeService.getEntidadeLogada();
        Specification specification = new RsqlSpecification(this.entityManager, search).and(UsuarioSpecificationHelper.isInEntidade((Long)entidadeLogada, (Boolean)isAdm));
        Page usuariosPage = this.usuarioService.findAll(specification, pageable);
        Boolean isMaskUser = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_USUARIO_COM_MASCARA_COM_CPF_LGPD.getCodigo());
        Boolean isMaskCPF = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CPF_LGPD.getCodigo());
        Boolean isMaskCNPJ = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CNPJ_LGPD.getCodigo());
        return ResponseEntity.ok((Object)usuariosPage.map(usuario -> UsuarioEntidadeAtualDTO.fromUsuarioAndEntidade((Usuario)usuario, (Long)entidadeLogada, (Boolean)isMaskUser, (Boolean)isMaskCPF, (Boolean)isMaskCNPJ)));
    }

    @GetMapping(value={"/entidadeAtual/autocomplete"})
    public ResponseEntity<Page<UsuarioPermissaoLocalDTO>> findAllEntidadeAtualAutoComplete(@RequestParam(value="search", required=false) String search, @RequestParam(value="isAdm", required=false) Boolean isAdm, Pageable pageable) {
        Long entidadeLogada = this.entidadeService.getEntidadeLogada();
        Specification specification = new RsqlSpecification(this.entityManager, search).and(UsuarioSpecificationHelper.isInEntidade((Long)entidadeLogada, (Boolean)isAdm));
        Page usuariosPage = this.usuarioService.findAll(specification, pageable);
        return ResponseEntity.ok((Object)usuariosPage.map(usuario -> UsuarioUtils.createUsuarioLocalDtoFromUsuarioAndEntidade((Usuario)usuario, (Long)entidadeLogada)));
    }

    @PutMapping(value={"/entidadeAtual/{id}"})
    @Transactional
    public ResponseEntity<UsuarioDTO> updateEntidadeAtual(@RequestBody @Valid UsuarioEntidadeAtualDTO dto, @PathVariable String id, Authentication authentication) {
        ResponseEntity usuarioDTOResponseEntity = super.update((Object)dto, (Serializable)((Object)id), authentication);
        this.usuarioService.updateIsUsuarioAdministrador(dto.getAlteraTodosProc(), id, this.entidadeService.getEntidadeLogada());
        return usuarioDTOResponseEntity;
    }

    @PostMapping(value={"/entidadeAtual"})
    @Transactional
    public ResponseEntity<UsuarioDTO> createEntidadeAtual(@RequestBody @Valid UsuarioEntidadeAtualDTO dto, Authentication authentication, UriComponentsBuilder builder, HttpServletRequest request) {
        ResponseEntity usuarioDTO = super.save((Object)dto, authentication, builder, request);
        this.usuarioService.updateIsUsuarioAdministrador(dto.getAlteraTodosProc(), ((UsuarioDTO)usuarioDTO.getBody()).getId(), this.entidadeService.getEntidadeLogada());
        return usuarioDTO;
    }

    @Generated
    public UsuarioResource(ParametroService parametroService, UsuarioService usuarioService, EntidadeService entidadeService, EntityManager entityManager) {
        this.parametroService = parametroService;
        this.usuarioService = usuarioService;
        this.entidadeService = entidadeService;
        this.entityManager = entityManager;
    }
}

