/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Local;
import br.com.elotech.protocolo.domain.LocalPK;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.domain.UsuarioLocal;
import br.com.elotech.protocolo.domain.UsuarioLocalPK;
import br.com.elotech.protocolo.dto.UsuarioLocalDTO;
import br.com.elotech.protocolo.dto.UsuarioPermissaoLocalDTO;
import br.com.elotech.protocolo.service.UsuarioLocalService;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/usuarios-locais"})
public class UsuarioLocalResource
extends BaseResourceDTO<UsuarioLocal, UsuarioLocalPK, UsuarioLocalDTO> {
    public UsuarioLocalService getService() {
        return (UsuarioLocalService)super.getService();
    }

    @GetMapping(value={"/autocomplete/{local}"})
    public ResponseEntity<Page<UsuarioPermissaoLocalDTO>> getUsuariosByLocal(@PathVariable(value="local") Long local, @RequestParam(value="search", defaultValue="", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.getService().getUsuariosByLocal(local, search, pageable));
    }

    @GetMapping(value={"/autocomplete"})
    public ResponseEntity<Page<UsuarioPermissaoLocalDTO>> getUsuariosByEntidade(@RequestParam(value="search", defaultValue="", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.getService().getUsuariosByEntidade(search, pageable));
    }

    @GetMapping(value={"/local/{id}"})
    public ResponseEntity<List<UsuarioPermissaoLocalDTO>> findAllUsuariosByLocal(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.getService().findAllUsuariosByLocal(id));
    }

    @PostMapping(value={"/usuario/{usuario}"})
    public ResponseEntity<UsuarioPermissaoLocalDTO> saveUserByLocal(@PathVariable(value="usuario") String user, @RequestBody UsuarioLocalDTO dto) {
        return ResponseEntity.ok((Object)this.getService().addUserByLocal(user, dto));
    }

    @DeleteMapping(value={"/usuario/{usuario}/local/{local}"})
    public ResponseEntity<Void> remove(@PathVariable(value="usuario") String user, @PathVariable(value="local") Long localId) {
        Usuario usuario = new Usuario(user);
        Local local = new Local(LocalPK.of((Entidade)RequestHeaderHelper.getEntidadeContextHolder(), (Long)localId));
        this.getService().findById((Serializable)new UsuarioLocalPK(usuario, local)).ifPresent(ul -> super.remove((Serializable)ul.getId()));
        return ResponseEntity.ok().build();
    }
}

