/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.protocolo.domain.UsuarioAusencia;
import br.com.elotech.protocolo.dto.UsuarioAusenciaDTO;
import br.com.elotech.protocolo.service.UsuarioAusenciaService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/usuarios-ausencias"})
public class UsuarioAusenciaResource
extends BaseResourceDTO<UsuarioAusencia, Long, UsuarioAusenciaDTO> {
    @Autowired
    private UsuarioAusenciaService service;

    @GetMapping(value={"/ausencias/{usuario}"})
    public ResponseEntity<List<UsuarioAusenciaDTO>> findAusencias(@PathVariable(name="usuario") String usuarioId, @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @RequestParam(name="data", required=false) LocalDate data) {
        return ResponseEntity.ok((Object)this.service.findAusencias(usuarioId, data));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<UsuarioAusenciaDTO> findOne(@PathVariable Long id) {
        return super.findOne((Serializable)id);
    }

    @PostMapping
    public ResponseEntity<UsuarioAusenciaDTO> save(@RequestBody @Valid UsuarioAusenciaDTO dto, Authentication authentication, UriComponentsBuilder builder, HttpServletRequest request) {
        return super.save((Object)dto, authentication, builder, request);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<UsuarioAusenciaDTO> update(@RequestBody @Valid UsuarioAusenciaDTO dto, @PathVariable Long id, Authentication authentication) {
        return super.update((Object)dto, (Serializable)id, authentication);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable Long id) {
        return super.remove((Serializable)id);
    }
}

