/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Unidade;
import br.com.elotech.protocolo.domain.UnidadeOrcamentaria;
import br.com.elotech.protocolo.domain.UnidadeOrcamentariaPK;
import br.com.elotech.protocolo.domain.UnidadePK;
import br.com.elotech.protocolo.dto.UnidadeOrcamentariaDTO;
import br.com.elotech.protocolo.service.UnidadeService;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/unidadesorcamentaria"})
public class UnidadeOrcamentariaResource
extends BaseResourceDTO<UnidadeOrcamentaria, UnidadeOrcamentariaPK, UnidadeOrcamentariaDTO> {
    private final UnidadeService unidadeService;

    public UnidadeOrcamentariaResource(UnidadeService unidadeService) {
        this.unidadeService = unidadeService;
    }

    @RequestMapping(method={RequestMethod.GET}, params={"orgao", "codigo"})
    public ResponseEntity<UnidadeOrcamentariaDTO> findOne(@RequestParam(value="orgao") Long orgao, @RequestParam(value="codigo") Long codigo) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        Unidade unidade = (Unidade)this.unidadeService.findOne((Serializable)UnidadePK.of((Entidade)entidade, (Long)orgao));
        UnidadeOrcamentariaPK unidadeOrcamentariaPK = UnidadeOrcamentariaPK.of((Unidade)unidade, (Long)codigo);
        return super.findOne((Serializable)unidadeOrcamentariaPK);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<UnidadeOrcamentariaDTO> save(@RequestBody @Valid UnidadeOrcamentariaDTO dto, Authentication authentication, UriComponentsBuilder builder, HttpServletRequest request) {
        return super.save((Object)dto, authentication, builder, request);
    }

    @RequestMapping(method={RequestMethod.PUT})
    public ResponseEntity<UnidadeOrcamentariaDTO> update(@RequestBody @Valid UnidadeOrcamentariaDTO dto, Authentication authentication) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        Unidade unidade = (Unidade)this.unidadeService.findOne((Serializable)UnidadePK.of((Entidade)entidade, (Long)dto.getOrgao().getId()));
        UnidadeOrcamentariaPK unidadeOrcamentariaPK = UnidadeOrcamentariaPK.of((Unidade)unidade, (Long)dto.getCodigo());
        return super.update((Object)dto, (Serializable)unidadeOrcamentariaPK, authentication);
    }

    @RequestMapping(method={RequestMethod.DELETE}, params={"orgao", "codigo"})
    public ResponseEntity<Void> remove(@RequestParam(value="orgao") Long orgao, @RequestParam(value="codigo") Long codigo) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        Unidade unidade = (Unidade)this.unidadeService.findOne((Serializable)UnidadePK.of((Entidade)entidade, (Long)orgao));
        UnidadeOrcamentariaPK unidadeOrcamentariaPK = UnidadeOrcamentariaPK.of((Unidade)unidade, (Long)codigo);
        return super.remove((Serializable)unidadeOrcamentariaPK);
    }
}

