/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.dto.PessoaTributosDTO;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.dto.params.tributos.RequerimentoSimplificadoDTO;
import br.com.elotech.protocolo.feign.TributosClient;
import br.com.elotech.protocolo.function.PessoaToTributosDTO;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.protocolo.service.TributosService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tributos"})
public class TributosResource {
    private final TributosService service;
    private final ProcessoPesquisaService processoPesquisaService;
    private final TributosClient tributosClient;

    public TributosResource(TributosService service, ProcessoPesquisaService processoPesquisaService, TributosClient tributosClient) {
        this.service = service;
        this.processoPesquisaService = processoPesquisaService;
        this.tributosClient = tributosClient;
    }

    @GetMapping(value={"/integracao"})
    public ResponseEntity<Boolean> possuiIntegracaoTributos() {
        return ResponseEntity.ok((Object)this.service.integradoTributos());
    }

    @GetMapping(value={"/up"})
    public ResponseEntity<Boolean> isUp() {
        return ResponseEntity.ok((Object)this.service.tributosIsUP(this.service.getUrlTributosOrElseThrowUriTributosNaoConfiguradaException()));
    }

    @PostMapping(params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<Void> salvaPessoaProcesso(PesquisaProcessoParams params) {
        Processo processo = this.processoPesquisaService.loadProcesso(Entidade.of((Long)params.getEntidade()), params.getTipo(), params.getNumero(), params.getAno());
        PessoaTributosDTO pessoaTributosDTO = new PessoaToTributosDTO().apply(processo.getPessoa());
        this.service.salvarPessoaCadastroAvulsoTributos(pessoaTributosDTO);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/requerimentos/{entidade}/{exercicio}/{requerimento}"})
    public ResponseEntity<RequerimentoSimplificadoDTO> getRequerimentoResumido(@PathVariable(name="entidade") Long entidade, @PathVariable(name="exercicio") Long exercicio, @PathVariable(name="requerimento") Long requerimento) {
        return ResponseEntity.ok((Object)this.tributosClient.getRequerimentoSimplificado(entidade, exercicio, requerimento));
    }
}

