/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.protocolo.config.SecurityUtils;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.dto.ParecerAuditDTO;
import br.com.elotech.protocolo.dto.TramiteDTO;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.dto.params.PesquisaTramiteParams;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.protocolo.service.TramiteService;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tramites"})
public class TramiteResource {
    private final TramiteService tramiteService;
    private final ProcessoPesquisaService processoPesquisaService;

    @Autowired
    public TramiteResource(TramiteService tramiteService, ProcessoPesquisaService processoPesquisaService) {
        this.tramiteService = tramiteService;
        this.processoPesquisaService = processoPesquisaService;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/template/{funcao}"})
    public ResponseEntity<TramiteDTO> templateTramite(@RequestHeader(value="exercicio") Long exercicio, @PathVariable String funcao) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        Funcao funcaoEnum = Funcao.fromDescricao((String)funcao);
        TramiteDTO templateProcesso = this.tramiteService.initializeTemplate(funcaoEnum, entidade, exercicio);
        return ResponseEntity.ok().body((Object)templateProcesso);
    }

    @RequestMapping(method={RequestMethod.PUT}, params={"tipo", "numero", "ano", "entidade", "sequencia"})
    public ResponseEntity<TramiteDTO> updateParecer(@RequestBody TramiteDTO tramite, PesquisaTramiteParams params) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return ResponseEntity.ok().body((Object)this.tramiteService.updateParecer(params, Entidade.of((Long)params.getEntidade()), tramite.getParecer(), authentication.getName()));
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/parecer-requerente"}, params={"numero", "tipo", "ano", "entidade"})
    public ResponseEntity<TramiteDTO> updateParecerResposta(@RequestParam(value="cpfCnpj", defaultValue="", required=false) String cpfCnpj, @RequestBody TramiteDTO tramite, PesquisaProcessoParams params) {
        Processo processo = this.processoPesquisaService.findProcessoByPkAndUsuario(params.getAno(), params.getTipo(), params.getNumero(), params.getEntidade(), Optional.ofNullable(cpfCnpj).orElse(SecurityUtils.getUsername()));
        if (processo == null) {
            throw RestException.notFound((String)"Processo n\u00e3o existe ou voc\u00ea n\u00e3o possui permiss\u00e3o para alterar o tramite desse processo.");
        }
        return ResponseEntity.ok().body((Object)this.tramiteService.updateParecerResposta(processo, tramite));
    }

    @GetMapping(value={"/listaAlteracaoParecer"}, params={"tipo", "numero", "ano", "entidade", "sequencia"})
    public ResponseEntity<List<ParecerAuditDTO>> listaAlteracaoParecer(Long tipo, Long numero, Long ano, Long entidade, Long sequencia) {
        return ResponseEntity.ok((Object)this.tramiteService.listaAlteracaoParecer(numero, tipo, ano, sequencia, entidade));
    }
}

