/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.audit.domain.RevisionRecord;
import br.com.elotech.audit.reader.RevisionReader;
import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.dto.TipoProcessoDTO;
import br.com.elotech.protocolo.service.TipoProcessoService;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/tiposprocesso"})
public class TipoProcessoResource
extends BaseResourceDTO<TipoProcesso, Long, TipoProcessoDTO> {
    private final RevisionReader reader;
    private final TipoProcessoService tipoProcessoService;

    public TipoProcessoResource(RevisionReader reader, TipoProcessoService tipoProcessoService) {
        this.reader = reader;
        this.tipoProcessoService = tipoProcessoService;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    public ResponseEntity<TipoProcessoDTO> findOne(@PathVariable(value="id") Long id) {
        return super.findOne((Serializable)id);
    }

    @GetMapping(value={"/find-all-filtrado-entidade"})
    public ResponseEntity<List<TipoProcessoDTO>> findAllNew(@RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="entidadeAtual", required=false) Long entidadeAtual, Pageable pageable) {
        return ResponseEntity.ok((Object)this.tipoProcessoService.findAllComFiltroDeEntidade(search, entidadeAtual, pageable));
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<TipoProcessoDTO> save(@RequestBody @Valid TipoProcessoDTO dto, Authentication authentication, UriComponentsBuilder builder, HttpServletRequest request) {
        return super.save((Object)dto, authentication, builder, request);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    public ResponseEntity<TipoProcessoDTO> update(@RequestBody @Valid TipoProcessoDTO dto, @PathVariable(value="id") Long id, Authentication authentication) {
        return super.update((Object)dto, (Serializable)id, authentication);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable(value="id") Long id) {
        return super.remove((Serializable)id);
    }

    @GetMapping(value={"/history"}, params={"id"})
    public ResponseEntity<List<RevisionRecord>> findAllHistory(Long id) {
        return ResponseEntity.ok((Object)this.reader.findHistory(TipoProcesso.class, (Serializable)id));
    }

    @PostMapping(value={"/republish"})
    public ResponseEntity<Void> republish() {
        this.tipoProcessoService.republish();
        return ResponseEntity.ok().build();
    }
}

