/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.protocolo.domain.Assunto;
import br.com.elotech.protocolo.domain.ProcessoTaxa;
import br.com.elotech.protocolo.domain.ProcessoTaxaItem;
import br.com.elotech.protocolo.dto.TaxaServicoDTO;
import br.com.elotech.protocolo.repository.ProcessoTaxaRepository;
import br.com.elotech.protocolo.service.AssuntoService;
import br.com.elotech.protocolo.service.TaxaAssuntoService;
import br.com.elotech.protocolo.service.TributosService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/taxas-assunto"})
public class TaxaAssuntoResource {
    private final TributosService tributosService;
    private final AssuntoService assuntoService;
    private final TaxaAssuntoService taxaAssuntoService;
    private final ProcessoTaxaRepository processoTaxaRepository;

    public TaxaAssuntoResource(TributosService tributosService, AssuntoService assuntoService, TaxaAssuntoService taxaAssuntoService, ProcessoTaxaRepository processoTaxaRepository) {
        this.tributosService = tributosService;
        this.assuntoService = assuntoService;
        this.taxaAssuntoService = taxaAssuntoService;
        this.processoTaxaRepository = processoTaxaRepository;
    }

    @GetMapping(value={"/assunto/{idAssunto}"})
    public ResponseEntity<List<TaxaServicoDTO>> findAllByAssunto(@PathVariable(name="idAssunto") Long idAssunto) {
        Assunto assunto = (Assunto)this.assuntoService.findOne((Serializable)idAssunto);
        if (Objects.isNull(assunto)) {
            throw new RestException(HttpStatus.NOT_FOUND, String.format("Assunto com c\u00f3digo %s n\u00e3o encontrado.", idAssunto));
        }
        if (assunto.getPossuiTaxas().booleanValue() && this.tributosService.integradoTributos()) {
            return ResponseEntity.ok((Object)this.taxaAssuntoService.findTaxaAssuntoByAssunto(assunto.getId()));
        }
        return ResponseEntity.ok(new ArrayList());
    }

    @GetMapping(value={"/processo-taxa/{idProcessoTaxa}"})
    public ResponseEntity<List<ProcessoTaxaItem>> findAllByProcessoTaxa(@PathVariable(name="idProcessoTaxa") Long idProcessoTaxa) {
        ProcessoTaxa processoTaxa = (ProcessoTaxa)this.processoTaxaRepository.findOne((Object)idProcessoTaxa);
        if (Objects.isNull(processoTaxa)) {
            throw new RestException(HttpStatus.NOT_FOUND, String.format("Taxas Processo com c\u00f3digo %s n\u00e3o encontrado.", idProcessoTaxa));
        }
        return ResponseEntity.ok((Object)processoTaxa.getItens());
    }
}

