/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.protocolo.domain.Situacao;
import br.com.elotech.protocolo.dto.SituacaoDTO;
import br.com.elotech.protocolo.service.SituacaoService;
import java.io.Serializable;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/situacoes"})
public class SituacaoResource
extends BaseResourceDTO<Situacao, Long, SituacaoDTO> {
    private final SituacaoService service;

    public SituacaoService getService() {
        return (SituacaoService)super.getService();
    }

    @GetMapping(value={"/find-all/{tipoProcesso}"})
    public ResponseEntity<Page<SituacaoDTO>> findAll(@PathVariable Long tipoProcesso, @RequestParam(value="search", required=false) Optional<String> search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.service.findAll(tipoProcesso, search, pageable));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    public ResponseEntity<SituacaoDTO> findOne(@PathVariable Long id) {
        return super.findOne((Serializable)id);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<SituacaoDTO> save(@RequestBody @Valid SituacaoDTO dto, Authentication authentication, UriComponentsBuilder builder, HttpServletRequest request) {
        return super.save((Object)dto, authentication, builder, request);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    public ResponseEntity<SituacaoDTO> update(@RequestBody @Valid SituacaoDTO dto, @PathVariable(value="id") Long id, Authentication authentication) {
        return super.update((Object)dto, (Serializable)id, authentication);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable(value="id") Long id) {
        return super.remove((Serializable)id);
    }

    @PostMapping(value={"/republish"})
    public ResponseEntity<Void> republish() {
        this.getService().republish();
        return ResponseEntity.ok().build();
    }

    @Generated
    public SituacaoResource(SituacaoService service) {
        this.service = service;
    }
}

