/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Secretaria;
import br.com.elotech.protocolo.domain.SecretariaPK;
import br.com.elotech.protocolo.dto.SecretariaDTO;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/secretarias"})
public class SecretariaResource
extends BaseResourceDTO<Secretaria, SecretariaPK, SecretariaDTO> {
    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    public ResponseEntity<SecretariaDTO> findOne(@PathVariable Long id) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        SecretariaPK secretariaPK = SecretariaPK.of((Entidade)entidade, (Long)id);
        return super.findOne((Serializable)secretariaPK);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<SecretariaDTO> save(@RequestBody @Valid SecretariaDTO dto, Authentication authentication, UriComponentsBuilder builder, HttpServletRequest request) {
        return super.save((Object)dto, authentication, builder, request);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}"})
    public ResponseEntity<SecretariaDTO> update(@RequestBody @Valid SecretariaDTO dto, @PathVariable Long id, Authentication authentication) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        SecretariaPK secretariaPK = SecretariaPK.of((Entidade)entidade, (Long)id);
        return super.update((Object)dto, (Serializable)secretariaPK, authentication);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable Long id) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        SecretariaPK secretariaPK = SecretariaPK.of((Entidade)entidade, (Long)id);
        return super.remove((Serializable)secretariaPK);
    }
}

