/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Roteiro;
import br.com.elotech.protocolo.dto.RoteiroDTO;
import br.com.elotech.protocolo.service.RoteiroService;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/roteiros"})
public class RoteiroResource
extends BaseResourceDTO<Roteiro, Long, RoteiroDTO> {
    private final RoteiroService roteiroService;

    public RoteiroResource(RoteiroService roteiroService) {
        this.roteiroService = roteiroService;
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<RoteiroDTO> findOne(@PathVariable Long id) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        return ResponseEntity.ok((Object)this.roteiroService.findOne(id, entidade));
    }

    @PostMapping
    public ResponseEntity<RoteiroDTO> save(@RequestBody @Valid RoteiroDTO dto, Authentication authentication, UriComponentsBuilder builder, HttpServletRequest request) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        return ResponseEntity.ok((Object)this.roteiroService.save(dto, entidade, authentication));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<RoteiroDTO> update(@RequestBody @Valid RoteiroDTO dto, @PathVariable(value="id") Long id, Authentication authentication) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        return ResponseEntity.ok((Object)this.roteiroService.save(dto, entidade, authentication));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable(value="id") Long id) {
        return super.remove((Serializable)id);
    }
}

