/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Exercicio;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.UserInfoDTO;
import br.com.elotech.protocolo.service.ExercicioService;
import br.com.elotech.protocolo.service.UsuarioService;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ProtocoloUserinfoResource {
    private final UsuarioService usuarioService;
    private final ExercicioService exercicioService;
    private final ProtocoloMapper mapper;

    public ProtocoloUserinfoResource(UsuarioService usuarioService, ExercicioService exercicioService, ProtocoloMapper mapper) {
        this.usuarioService = usuarioService;
        this.exercicioService = exercicioService;
        this.mapper = mapper;
    }

    @GetMapping(value={"/userinfo"})
    public ResponseEntity<UserInfoDTO> getUsuarioPermissao(Authentication auth) {
        Usuario usuario = this.usuarioService.findUsuarioByName(auth.getName());
        Entidade entidadePadrao = this.getEntidadePadraoUsuario(auth.getName());
        Exercicio exercicioPadrao = this.exercicioService.getExercicioPadraoEntidade(entidadePadrao);
        UserInfoDTO user = this.mapper.toUsuarioPermissaoDTO(usuario);
        user.setEntidadePadrao(this.mapper.toEntidadeDTO(entidadePadrao));
        user.setExercicioPadrao(this.mapper.toExercicioDTO(exercicioPadrao));
        user.setEditarProcessoTramitado(usuario.getEditarProcessoTramitado());
        user.setOuvidor(usuario.getOuvidor());
        return ResponseEntity.ok((Object)user);
    }

    private Entidade getEntidadePadraoUsuario(String username) {
        return this.usuarioService.getUsuarioEntidadePadraoUsuario(username).getId().getEntidade();
    }
}

