/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.domain.AuthenticationDetails;
import br.com.elotech.core.security.jwt.TokenGenerator;
import br.com.elotech.core.web.rest.dto.LoginDTO;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.context.annotation.Profile;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
@Profile(value={"standalone"})
public class ProtocoloAuthenticationResource {
    private final TokenGenerator tokenGenerator;
    private final AuthenticationManager authenticationManager;

    public ProtocoloAuthenticationResource(TokenGenerator tokenGenerator, AuthenticationManager authenticationManager) {
        this.tokenGenerator = tokenGenerator;
        this.authenticationManager = authenticationManager;
    }

    @RequestMapping(value={"/api/authenticate"}, method={RequestMethod.POST})
    public ResponseEntity<AuthenticationDetails> authenticate(@Valid @RequestBody LoginDTO loginDTO, HttpServletResponse response) {
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)loginDTO.getUsername(), (Object)loginDTO.getPassword());
        Authentication authentication = this.authenticationManager.authenticate((Authentication)authenticationToken);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        boolean rememberMe = BooleanUtils.isTrue((Boolean)loginDTO.isRememberMe());
        String jwt = this.tokenGenerator.createToken(authentication, Boolean.valueOf(rememberMe));
        response.addHeader("Authorization", "Bearer " + jwt);
        AuthenticationDetails.AuthenticationDetailsBuilder authenticationDetails = AuthenticationDetails.builder().token(jwt);
        return ResponseEntity.ok((Object)authenticationDetails.build());
    }
}

