/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.dto.params.PesquisaMultiplosProcessosParams;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.protocolo.service.ProcessoValidacaoService;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/processos/validacao"})
public class ProcessoValidacaoResource {
    private final ProcessoValidacaoService processoValidacaoService;
    private final ProcessoPesquisaService processoPesquisaService;

    public ProcessoValidacaoResource(ProcessoValidacaoService processoValidacaoService, ProcessoPesquisaService processoPesquisaService) {
        this.processoValidacaoService = processoValidacaoService;
        this.processoPesquisaService = processoPesquisaService;
    }

    @GetMapping(value={"/encaminhamento"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<Void> validarEncaminhamento(PesquisaMultiplosProcessosParams params) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.RECEBIDO});
        List processos = this.findProcessosByFuncao(params, (Set)funcoes, auth.getName());
        this.processoValidacaoService.validarEncaminhamentoProcesso(processos);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/recebimento"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<Void> validarRecebimento(PesquisaMultiplosProcessosParams params) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.ENCAMINHADO});
        List processos = this.findProcessosByFuncao(params, (Set)funcoes, auth.getName());
        this.processoValidacaoService.validarRecebimentoProcesso(processos);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/arquivamento"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<Void> validarArquivamento(PesquisaMultiplosProcessosParams params) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.ABERTO, Funcao.RECEBIDO, Funcao.ENCAMINHADO});
        List processos = this.findProcessosByFuncao(params, (Set)funcoes, auth.getName());
        this.processoValidacaoService.validarArquivamentoProcesso(processos);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/reabertura"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<Void> validarReabertura(PesquisaMultiplosProcessosParams params) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.ARQUIVADO});
        List processos = this.findProcessosByFuncao(params, (Set)funcoes, auth.getName());
        this.processoValidacaoService.validarArquivamentoProcesso(processos);
        return ResponseEntity.ok().build();
    }

    private List<Processo> findProcessosByFuncao(PesquisaMultiplosProcessosParams params, Set<Funcao> funcoes, String user) {
        return this.processoPesquisaService.getProcessosByFuncao(user, params.getTipo(), params.getNumero(), params.getAno(), funcoes);
    }
}

