/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.protocolo.converter.ProcessoUsuarioViewDTOConverter;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.ProcessoUsuarioView;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.dto.ProcessoUsuarioViewDTO;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.ProcessoUsuarioViewService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/processos/usuarios/view"})
public class ProcessoUsuarioViewResource
extends ReadOnlyResource<ProcessoUsuarioView, String> {
    private final ProcessoUsuarioViewService service;
    private final ParametroService parametroService;

    public ProcessoUsuarioViewResource(ProcessoUsuarioViewService service, ParametroService parametroService) {
        this.service = service;
        this.parametroService = parametroService;
    }

    @PostMapping(params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<Void> saveUsuarioView(PesquisaProcessoParams params) {
        long idEntidade = params.getEntidade();
        ProcessoPK processoPK = ProcessoPK.of((Entidade)new Entidade(Long.valueOf(idEntidade)), (TipoProcesso)new TipoProcesso(params.getTipo()), (Long)params.getNumero(), (Long)params.getAno());
        this.service.save(processoPK);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    @RequestMapping(value={"/dto"}, method={RequestMethod.GET})
    public ResponseEntity<Page<ProcessoUsuarioViewDTO>> findAllDTO(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page processoUsuarioViews = this.service.findByRsql(search, pageable);
        ProcessoUsuarioViewDTOConverter processoUsuarioViewDTOConverter = new ProcessoUsuarioViewDTOConverter();
        Boolean isMaskUser = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_USUARIO_COM_MASCARA_COM_CPF_LGPD.getCodigo());
        Boolean isMaskCPF = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CPF_LGPD.getCodigo());
        Boolean isMaskCNPJ = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CNPJ_LGPD.getCodigo());
        return ResponseEntity.ok((Object)processoUsuarioViews.map(processoUsuarioView -> processoUsuarioViewDTOConverter.to(processoUsuarioView, isMaskUser, isMaskCPF, isMaskCNPJ)));
    }
}

