/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoTaxa;
import br.com.elotech.protocolo.dto.BoletoTributosDTO;
import br.com.elotech.protocolo.dto.StatusPagamentoDebitoDTO;
import br.com.elotech.protocolo.dto.TaxaServicoDTO;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.protocolo.service.ProcessoTaxaPagamentoService;
import br.com.elotech.protocolo.service.ProcessoTaxaService;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/processos/taxas"})
public class ProcessoTaxaResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoTaxaResource.class);
    private final ProcessoTaxaService processoTaxaService;
    private final ProcessoPesquisaService processoPesquisaService;
    private final ProcessoTaxaPagamentoService processoTaxaPagamentoService;

    public ProcessoTaxaResource(ProcessoTaxaService processoTaxaService, ProcessoPesquisaService processoPesquisaService, ProcessoTaxaPagamentoService processoTaxaPagamentoService) {
        this.processoTaxaService = processoTaxaService;
        this.processoPesquisaService = processoPesquisaService;
        this.processoTaxaPagamentoService = processoTaxaPagamentoService;
    }

    @PostMapping(params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<BoletoTributosDTO> emitirTaxa(PesquisaProcessoParams params, @RequestBody List<TaxaServicoDTO> taxas) {
        Processo processo = this.processoPesquisaService.loadProcesso(Entidade.of((Long)params.getEntidade()), params.getTipo(), params.getNumero(), params.getAno());
        Optional boletoTributosDTO = this.processoTaxaService.gerarTaxaPagamento(processo, taxas);
        return boletoTributosDTO.map(ResponseEntity::ok).orElse(ResponseEntity.ok().build());
    }

    @PostMapping(value={"/processo-taxa/{idProcessoTaxa}"})
    public ResponseEntity<BoletoTributosDTO> reemitirTaxa(@PathVariable(name="idProcessoTaxa") Long idProcessoTaxa) {
        ProcessoTaxa processoTaxa = this.processoTaxaService.findOne(idProcessoTaxa);
        if (Objects.isNull(processoTaxa)) {
            throw new RestException(HttpStatus.NOT_FOUND, String.format("Processo taxa com c\u00f3digo %s n\u00e3o encontrado.", idProcessoTaxa));
        }
        if (processoTaxa.getIdDebito() == null) {
            throw new RestException(HttpStatus.BAD_REQUEST, "Debito n\u00e3o vinculado ao processo. Verifique no sistema tribut\u00e1rio.");
        }
        Optional boletoTributosDTO = this.processoTaxaService.gerarBoleto(processoTaxa, LocalDate.now());
        return boletoTributosDTO.map(ResponseEntity::ok).orElse(ResponseEntity.ok().build());
    }

    @PostMapping(value={"/verificar-pagamento"}, params={"tipo", "numero", "ano"})
    public ResponseEntity<StatusPagamentoDebitoDTO> verificarStatusPagamento(PesquisaProcessoParams params, @RequestBody Entidade entidade) {
        Processo processo = this.processoPesquisaService.loadProcesso(entidade, params.getTipo(), params.getNumero(), params.getAno());
        return ResponseEntity.ok((Object)this.processoTaxaService.verificarStatusPagamento(processo).toStatusPagamentoDTO());
    }

    @GetMapping(value={"/atualizar-situacoes-pagamento"})
    public ResponseEntity<Void> atualizarSituacoesPagamento(@RequestParam(name="meses", required=false) Long meses) {
        log.debug("Iniciando atualiza\u00e7\u00e3o de situa\u00e7\u00e3o do pagamento, meses = {}", (Object)meses);
        this.processoTaxaPagamentoService.atualizaStatusPagamentoProcesso(meses);
        return ResponseEntity.ok().build();
    }
}

