/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.audit.domain.RevisionRecord;
import br.com.elotech.audit.reader.RevisionReader;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.core.web.rest.dto.DTOConverter;
import br.com.elotech.protocolo.config.SecurityUtils;
import br.com.elotech.protocolo.converter.ProcessoDTOConverter;
import br.com.elotech.protocolo.converter.ProcessoEnxutoDTOConverter;
import br.com.elotech.protocolo.domain.Caixa;
import br.com.elotech.protocolo.domain.CaixaPK;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.dto.AcessoProcessoDTO;
import br.com.elotech.protocolo.dto.ArquivoDocumentoDTO;
import br.com.elotech.protocolo.dto.AssuntoDTO;
import br.com.elotech.protocolo.dto.AvaliacaoProcessoDTO;
import br.com.elotech.protocolo.dto.CaixaDTO;
import br.com.elotech.protocolo.dto.ConfigLGPDCPFCNPJ;
import br.com.elotech.protocolo.dto.ConfigRestricao;
import br.com.elotech.protocolo.dto.EntidadeDTO;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.dto.LocalDTO;
import br.com.elotech.protocolo.dto.ProcessoAssuntoDTO;
import br.com.elotech.protocolo.dto.ProcessoContagemMesAnoDTO;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.ProcessoEnxutoDTO;
import br.com.elotech.protocolo.dto.ProcessoIntegracaoDTO;
import br.com.elotech.protocolo.dto.ProcessoSaveRequestDTO;
import br.com.elotech.protocolo.dto.ReferenciarProcessoDTO;
import br.com.elotech.protocolo.dto.RequerimentoObservacaoProcessoAuditDTO;
import br.com.elotech.protocolo.dto.SituacaoDTO;
import br.com.elotech.protocolo.dto.TramiteDTO;
import br.com.elotech.protocolo.dto.TramiteProcessosWrapper;
import br.com.elotech.protocolo.dto.params.PesquisaMultiplosProcessosParams;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.dto.params.TramitacaoListagemParams;
import br.com.elotech.protocolo.exception.OperacaoNaoPermitidaException;
import br.com.elotech.protocolo.exception.RegistroNaoEncontradoException;
import br.com.elotech.protocolo.repository.TipoProcessoRepository;
import br.com.elotech.protocolo.service.CaixaService;
import br.com.elotech.protocolo.service.CorrecaoFluxoService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.ProcessoArquivoService;
import br.com.elotech.protocolo.service.ProcessoPermissaoService;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.protocolo.service.ProcessoService;
import br.com.elotech.protocolo.service.ProcessoValidacaoService;
import br.com.elotech.protocolo.service.RestricaoService;
import br.com.elotech.protocolo.strategy.TramiteBusinessStrategy;
import br.com.elotech.protocolo.strategy.impl.tramite.TramiteAlterarCaixaStrategy;
import br.com.elotech.protocolo.web.controller.params.RelatorioContagemMesAnoParams;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/processos"})
public class ProcessoResource
extends BaseResourceDTO<Processo, ProcessoPK, ProcessoDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoResource.class);
    protected static final Long QTD_MESES = 6L;
    private static final Long QTD_MAXIMA_TRAMITES = 2L;
    private final RevisionReader reader;
    private final ProcessoService processoService;
    private final ProcessoPesquisaService processoPesquisaService;
    private final ProcessoArquivoService processoArquivoService;
    private final CorrecaoFluxoService correcaoFluxoservice;
    private final ProcessoPermissaoService processoPermissaoService;
    private final CaixaService caixaService;
    private final ProtocoloMapper mapperProtocolo;
    private final ProcessoValidacaoService processoValidacaoService;
    private final ParametroService parametroService;
    private final TipoProcessoRepository tipoProcessoRepository;
    private final RestricaoService restricaoService;

    public ProcessoResource(RevisionReader reader, ProcessoService processoService, ProcessoPesquisaService processoPesquisaService, ProcessoArquivoService processoArquivoService, CorrecaoFluxoService correcaoFluxoservice, ProcessoPermissaoService processoPermissaoService, CaixaService caixaService, ProtocoloMapper mapperProtocolo, ProcessoValidacaoService processoValidacaoService, ParametroService parametroService, TipoProcessoRepository tipoProcessoRepository, RestricaoService restricaoService) {
        this.reader = reader;
        this.processoService = processoService;
        this.processoPesquisaService = processoPesquisaService;
        this.processoArquivoService = processoArquivoService;
        this.correcaoFluxoservice = correcaoFluxoservice;
        this.processoPermissaoService = processoPermissaoService;
        this.caixaService = caixaService;
        this.mapperProtocolo = mapperProtocolo;
        this.processoValidacaoService = processoValidacaoService;
        this.parametroService = parametroService;
        this.tipoProcessoRepository = tipoProcessoRepository;
        this.restricaoService = restricaoService;
    }

    @GetMapping(params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<ProcessoDTO> findProcessoWithEntidade(PesquisaProcessoParams params) {
        return this.getProcessoByPesquisaParams(params);
    }

    @GetMapping(params={"tipo", "numero", "ano"})
    public ResponseEntity<ProcessoDTO> findProcesso(PesquisaProcessoParams params) {
        return this.getProcessoByPesquisaParams(params);
    }

    private ResponseEntity<ProcessoDTO> getProcessoByPesquisaParams(PesquisaProcessoParams params) {
        Entidade entidade;
        Processo processo;
        ConfigRestricao configRestricao = this.restricaoService.getConfigRestricao();
        if (!this.restricaoService.permiteAcessoAoProcesso(configRestricao, processo = this.processoPesquisaService.loadProcesso(entidade = Objects.nonNull(params.getEntidade()) ? new Entidade(params.getEntidade()) : RequestHeaderHelper.getEntidadeContextHolder(), params.getTipo(), params.getNumero(), params.getAno())).booleanValue()) {
            throw new RestException(HttpStatus.FORBIDDEN, "Visualiza\u00e7\u00e3o bloqueada. O usu\u00e1rio n\u00e3o possui acesso aos locais aos quais o processo teve tramita\u00e7\u00e3o, n\u00e3o possui permiss\u00e3o para o tipo do processo ou est\u00e1 classificado como sigiloso.");
        }
        Boolean isMaskCPF = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CPF_LGPD.getCodigo());
        Boolean isMaskCNPJ = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CNPJ_LGPD.getCodigo());
        Boolean isMaskUser = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_USUARIO_COM_MASCARA_COM_CPF_LGPD.getCodigo());
        Boolean isOrdemCrescenteAnexo = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_CRESCENTE_ANEXO.getCodigo());
        Boolean isOrdemDecrescenteApenasCampoCalculado = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_DECRESCENTE_ANEXO.getCodigo());
        ProcessoDTOConverter processoDTOConverter = new ProcessoDTOConverter();
        ProcessoDTO dto = processoDTOConverter.to(processo, isMaskCPF, isMaskCNPJ, isMaskUser, isOrdemCrescenteAnexo, isOrdemDecrescenteApenasCampoCalculado);
        dto.setProcessoPai(this.processoService.getProcessoPai(processo.getId()));
        dto.getTramites().forEach(t -> t.setQuantidadeDiasLocal(TramiteDTO.getDiasParadoSetor((List)dto.getTramites(), (TramiteDTO)t)));
        return ResponseEntity.ok((Object)dto);
    }

    @GetMapping(value={"/processo-arquivado"}, params={"tipo", "numero", "ano"})
    public ResponseEntity<List<ProcessoDTO>> getProcessoArquivado(PesquisaProcessoParams params) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.ARQUIVADO});
        List processos = this.processoPesquisaService.getProcessosByFuncao(auth.getName(), params.getTipo(), params.getNumero().toString(), params.getAno(), (Set)funcoes);
        this.processoValidacaoService.validarReaberturaProcesso(processos);
        return ResponseEntity.ok().body((Object)this.collectionToDTO(processos));
    }

    @GetMapping(value={"/permissoes"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<AcessoProcessoDTO> checkProcessoPermissions(PesquisaProcessoParams params) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Entidade entidade = new Entidade(params.getEntidade());
        return ResponseEntity.ok((Object)this.processoPermissaoService.checkPermissionsProcesso(this.processoPesquisaService.loadProcesso(entidade, params.getTipo(), params.getNumero(), params.getAno()), authentication.getName()));
    }

    @GetMapping(value={"/lista"})
    public ResponseEntity<Page<ProcessoEnxutoDTO>> findAllLista(@RequestParam(value="search", required=false) Optional<String> search, Pageable pageable, HttpServletRequest request) {
        log.debug("Inicio met\u00f3do findAll.");
        log.debug("Buscando config de restricoes.");
        ConfigRestricao configRestricao = this.restricaoService.getConfigRestricao();
        log.debug("Finalizando config de restri\u00e7\u00f5es.");
        TramitacaoListagemParams params = new TramitacaoListagemParams();
        params.setSearch(search.orElse(""));
        params.setPageable(pageable);
        params.setUsuario(configRestricao.getUsuario().getId());
        log.debug("Busca configLGPD.  ");
        ConfigLGPDCPFCNPJ configLGPDCPFCNPJ = this.parametroService.getConfigLgpdcpfcnpj();
        log.debug("Inicio da busca dos processos.  ");
        Page processos = this.processoPesquisaService.getProcessos(params, configRestricao);
        log.debug("Fim da busca dos processos. ");
        log.debug("Inicio do transformer em ProcessoDTO.");
        Boolean isOrdemCrescenteAnexo = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_CRESCENTE_ANEXO.getCodigo());
        Long quantidadeDiasAvisoAVencer = this.parametroService.getParamValueAsLong(ParametroEnum.QTD_DIAS_AVENCER_MP.getCodigo());
        List result = processos.stream().map(processo -> new ProcessoEnxutoDTOConverter().to(processo, configLGPDCPFCNPJ, this.restricaoService.permiteAcessoAoProcesso(configRestricao, processo), isOrdemCrescenteAnexo, quantidadeDiasAvisoAVencer)).collect(Collectors.toList());
        log.debug("Fim do transformer em ProcessoDTO");
        return ResponseEntity.ok().body((Object)new PageImpl(result, pageable, processos.getTotalElements()));
    }

    @PostMapping
    @Transactional
    public ResponseEntity<ProcessoDTO> save(@RequestBody @Valid ProcessoDTO dto, Authentication authentication, UriComponentsBuilder builder, HttpServletRequest request) {
        if (authentication == null) {
            authentication = SecurityContextHolder.getContext().getAuthentication();
        }
        return super.save((Object)dto, authentication, builder, request);
    }

    @PostMapping(value={"/criar-processo-com-arquivos"})
    @Transactional
    public ResponseEntity<ProcessoDTO> createProcessWithFiles(@RequestBody @Valid ProcessoSaveRequestDTO dto, Authentication authentication, UriComponentsBuilder builder, HttpServletRequest request) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        ProcessoDTO saved = Objects.requireNonNull((ProcessoDTO)this.save(dto.getProcesso(), authentication, builder, request).getBody(), "Ocorreu uma falha ao salvar o Processo");
        ProcessoPK id = ProcessoPK.of((Entidade)Entidade.of((Long)saved.getEntidade().getId()), (TipoProcesso)TipoProcesso.of((Long)saved.getTipo().getId()), (Long)saved.getNumero(), (Long)saved.getAno());
        ProcessoDTO finalProcess = this.processoService.findById((Serializable)id).map(processo -> {
            ProcessoDTO dtoWithFile = saved;
            for (ArquivoDocumentoDTO arquivo : dto.getArquivos()) {
                dtoWithFile = this.processoArquivoService.vincularArquivoProcesso(processo, arquivo, auth.getName());
            }
            return dtoWithFile;
        }).orElse(saved);
        return ResponseEntity.ok((Object)finalProcess);
    }

    @PostMapping(value={"/criar-processo-integracao"})
    public ResponseEntity<ProcessoDTO> criarProcessoIntegracao(@RequestBody ProcessoIntegracaoDTO processoIntegracaoDTO) {
        return ResponseEntity.ok((Object)this.processoService.criarProcessoIntegracao(processoIntegracaoDTO));
    }

    @PutMapping(params={"tipo", "numero", "ano", "entidade"})
    @Transactional
    public ResponseEntity<ProcessoDTO> update(@RequestBody @Valid ProcessoDTO dto, PesquisaProcessoParams params) {
        boolean requerenteNaoPodeSerAlterado;
        Entidade entidade = Entidade.of((Long)params.getEntidade());
        ProcessoPK id = this.processoPesquisaService.loadPkById(params.getTipo(), params.getNumero(), params.getAno(), entidade);
        Processo processo = (Processo)this.processoService.findOne((Serializable)id);
        boolean bl = requerenteNaoPodeSerAlterado = Objects.nonNull(processo.getPessoa()) && !dto.getPessoa().getId().equals(processo.getPessoa().getId()) && (long)processo.getTramites().size() > QTD_MAXIMA_TRAMITES;
        if (requerenteNaoPodeSerAlterado) {
            throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o \u00e9 poss\u00edvel alterar o requerente de um processo com duas ou mais tramita\u00e7\u00f5es.");
        }
        if (!processo.isAberto().booleanValue() && !this.processoService.permiteUsuarioEditarProcessoTramitado()) {
            throw new OperacaoNaoPermitidaException("Opera\u00e7\u00e3o n\u00e3o permitida. Processo n\u00e3o est\u00e1 'Aberto'");
        }
        return super.update((Object)dto, (Serializable)id, SecurityContextHolder.getContext().getAuthentication());
    }

    @PostMapping(value={"/tramitar"})
    public ResponseEntity<List<ProcessoDTO>> tramitar(@RequestBody @Valid TramiteProcessosWrapper dto) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        List processos = dto.getProcessos().stream().map(i -> this.processoPesquisaService.loadProcesso(Entidade.of((Long)i.getEntidade().getId()), i.getTipo().getId(), i.getNumero(), i.getAno())).collect(Collectors.toList());
        if (processos.size() > 1 && Processo.possuiProcessoComControleDeTramitacao(processos).booleanValue() && Funcao.ENCAMINHADO.equals((Object)dto.getFuncao())) {
            throw new RestException(HttpStatus.BAD_REQUEST, "S\u00f3 \u00e9 poss\u00edvel tramitar um processo com controle de tramita\u00e7\u00e3o por vez!");
        }
        return ResponseEntity.ok().body((Object)this.collectionToDTO(this.processoService.tramitar(processos, dto, entidade, authentication.getName())));
    }

    @GetMapping(value={"/referenciados"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<List<ProcessoDTO>> findProcessosReferenciados(PesquisaProcessoParams params) {
        Entidade entidade = Entidade.of((Long)params.getEntidade());
        Processo processo = this.processoPesquisaService.loadProcesso(entidade, params.getTipo(), params.getNumero(), params.getAno());
        List processos = this.processoPesquisaService.getProcessosReferenciados(processo);
        return ResponseEntity.ok().body((Object)this.collectionToDTO(processos));
    }

    @GetMapping(value={"/referenciados-and-principal"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<List<ProcessoDTO>> findProcessosReferenciadosAndPrincipal(PesquisaProcessoParams params) {
        Entidade entidade = Entidade.of((Long)params.getEntidade());
        Processo processo = this.processoPesquisaService.loadProcesso(entidade, params.getTipo(), params.getNumero(), params.getAno());
        List processos = this.processoPesquisaService.getTodosProcessosReferenciadosAndPrincipal(processo);
        return ResponseEntity.ok().body((Object)this.collectionToDTO(processos));
    }

    @PostMapping(value={"/referenciados"})
    public ResponseEntity<ProcessoDTO> referenciar(@RequestBody ReferenciarProcessoDTO dto) {
        Processo processoReferenciado = this.processoPesquisaService.loadProcesso(Entidade.of((Long)dto.getProcessoReferenciado().getEntidade().getId()), dto.getProcessoReferenciado().getTipo().getId(), dto.getProcessoReferenciado().getNumero(), dto.getProcessoReferenciado().getAno());
        Processo processoReferencia = this.processoPesquisaService.loadProcesso(Entidade.of((Long)dto.getProcessoReferencia().getEntidade().getId()), dto.getProcessoReferencia().getTipo().getId(), dto.getProcessoReferencia().getNumero(), dto.getProcessoReferencia().getAno());
        Processo processoReferenciadoSave = this.processoService.referenciarProcesso(processoReferencia, processoReferenciado);
        return ResponseEntity.ok().body((Object)((ProcessoDTO)this.getConverter().to((EloEntity)processoReferenciadoSave)));
    }

    @DeleteMapping(value={"/referenciados"})
    public ResponseEntity<ProcessoDTO> deleteReferencia(@RequestBody ReferenciarProcessoDTO dto) {
        Entidade entidade = Entidade.of((Long)dto.getProcessoReferenciado().getEntidade().getId());
        Processo processoReferenciado = this.processoPesquisaService.loadProcesso(entidade, dto.getProcessoReferenciado().getTipo().getId(), dto.getProcessoReferenciado().getNumero(), dto.getProcessoReferenciado().getAno());
        Processo processoSemReferencia = this.processoService.removerProcessoReferenciado(processoReferenciado);
        return ResponseEntity.ok().body((Object)((ProcessoDTO)this.getConverter().to((EloEntity)processoSemReferencia)));
    }

    @PostMapping(value={"/referenciados/clone-arquivos"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<Void> cloneArquivos(PesquisaProcessoParams params) {
        this.processoService.cloneArquivoReferenciado(params);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/lista-recebimento"})
    public ResponseEntity<Page<ProcessoEnxutoDTO>> listarProcessosReceber(@RequestParam(value="filtrarResponsavelTramite", required=false, defaultValue="false") String filtrarResponsavelTramite, Pageable pageable, TramitacaoListagemParams params) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        params.setUsuario(authentication.getName());
        params.setPageable(pageable);
        ConfigLGPDCPFCNPJ configLGPDCPFCNPJ = this.parametroService.getConfigLgpdcpfcnpj();
        ConfigRestricao configRestricao = this.restricaoService.getConfigRestricao();
        Page processos = this.processoPesquisaService.listarProcessosReceber(params, Boolean.valueOf(filtrarResponsavelTramite));
        Boolean isOrdemCrescenteAnexo = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_CRESCENTE_ANEXO.getCodigo());
        Long quantidadeDiasAvisoAVencer = this.parametroService.getParamValueAsLong(ParametroEnum.QTD_DIAS_AVENCER_MP.getCodigo());
        return ResponseEntity.ok().body((Object)processos.map(processo -> new ProcessoEnxutoDTOConverter().to(processo, configLGPDCPFCNPJ, this.restricaoService.permiteAcessoAoProcesso(configRestricao, processo), isOrdemCrescenteAnexo, quantidadeDiasAvisoAVencer)));
    }

    @GetMapping(value={"/lista-encaminhamento"})
    public ResponseEntity<Page<ProcessoEnxutoDTO>> listarProcessosEncaminhar(@RequestParam(value="filtrarResponsavelTramite", required=false, defaultValue="false") String filtrarResponsavelTramite, Pageable pageable, TramitacaoListagemParams params) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        params.setUsuario(authentication.getName());
        params.setPageable(pageable);
        ConfigLGPDCPFCNPJ configLGPDCPFCNPJ = this.parametroService.getConfigLgpdcpfcnpj();
        ConfigRestricao configRestricao = this.restricaoService.getConfigRestricao();
        Page processos = this.processoPesquisaService.listarProcessosEncaminhar(params, Boolean.valueOf(filtrarResponsavelTramite), Boolean.FALSE);
        Boolean isOrdemCrescenteAnexo = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_CRESCENTE_ANEXO.getCodigo());
        Long quantidadeDiasAvisoAVencer = this.parametroService.getParamValueAsLong(ParametroEnum.QTD_DIAS_AVENCER_MP.getCodigo());
        return ResponseEntity.ok().body((Object)processos.map(processo -> new ProcessoEnxutoDTOConverter().to(processo, configLGPDCPFCNPJ, this.restricaoService.permiteAcessoAoProcesso(configRestricao, processo), isOrdemCrescenteAnexo, quantidadeDiasAvisoAVencer)));
    }

    @GetMapping(value={"/lista-favoritos"})
    public ResponseEntity<Page<ProcessoEnxutoDTO>> listarProcessosFavoritos(Pageable pageable, TramitacaoListagemParams params) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        params.setUsuario(authentication.getName());
        params.setPageable(pageable);
        ConfigLGPDCPFCNPJ configLGPDCPFCNPJ = this.parametroService.getConfigLgpdcpfcnpj();
        ConfigRestricao configRestricao = this.restricaoService.getConfigRestricao();
        Page processos = this.processoPesquisaService.listarProcessosFavoritos(params);
        Boolean isOrdemCrescenteAnexo = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_CRESCENTE_ANEXO.getCodigo());
        Long quantidadeDiasAvisoAVencer = this.parametroService.getParamValueAsLong(ParametroEnum.QTD_DIAS_AVENCER_MP.getCodigo());
        return ResponseEntity.ok().body((Object)processos.map(processo -> new ProcessoEnxutoDTOConverter().to(processo, configLGPDCPFCNPJ, this.restricaoService.permiteAcessoAoProcesso(configRestricao, processo), isOrdemCrescenteAnexo, quantidadeDiasAvisoAVencer)));
    }

    @GetMapping(value={"/lista-arquivado"})
    public ResponseEntity<Page<ProcessoEnxutoDTO>> listarProcessoArquivados(Pageable pageable, TramitacaoListagemParams params) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        params.setUsuario(authentication.getName());
        params.setPageable(pageable);
        ConfigLGPDCPFCNPJ configLGPDCPFCNPJ = this.parametroService.getConfigLgpdcpfcnpj();
        ConfigRestricao configRestricao = this.restricaoService.getConfigRestricao();
        Page processos = this.processoPesquisaService.listarProcessosArquivados(params);
        Boolean isOrdemCrescenteAnexo = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_CRESCENTE_ANEXO.getCodigo());
        Long quantidadeDiasAvisoAVencer = this.parametroService.getParamValueAsLong(ParametroEnum.QTD_DIAS_AVENCER_MP.getCodigo());
        return ResponseEntity.ok().body((Object)processos.map(processo -> new ProcessoEnxutoDTOConverter().to(processo, configLGPDCPFCNPJ, this.restricaoService.permiteAcessoAoProcesso(configRestricao, processo), isOrdemCrescenteAnexo, quantidadeDiasAvisoAVencer)));
    }

    @GetMapping(value={"/lista-arquivamento"})
    public ResponseEntity<Page<ProcessoEnxutoDTO>> listarProcessosArquivar(Pageable pageable, TramitacaoListagemParams params) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        params.setUsuario(authentication.getName());
        params.setPageable(pageable);
        ConfigLGPDCPFCNPJ configLGPDCPFCNPJ = this.parametroService.getConfigLgpdcpfcnpj();
        ConfigRestricao configRestricao = this.restricaoService.getConfigRestricao();
        Page processos = this.processoPesquisaService.listarProcessosArquivar(params);
        Boolean isOrdemCrescenteAnexo = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_CRESCENTE_ANEXO.getCodigo());
        Long quantidadeDiasAvisoAVencer = this.parametroService.getParamValueAsLong(ParametroEnum.QTD_DIAS_AVENCER_MP.getCodigo());
        return ResponseEntity.ok().body((Object)processos.map(processo -> new ProcessoEnxutoDTOConverter().to(processo, configLGPDCPFCNPJ, this.restricaoService.permiteAcessoAoProcesso(configRestricao, processo), isOrdemCrescenteAnexo, quantidadeDiasAvisoAVencer)));
    }

    @GetMapping(value={"/lista-vencidos"})
    public ResponseEntity<Page<ProcessoEnxutoDTO>> listarProcessosVencidos() {
        ConfigLGPDCPFCNPJ configLGPDCPFCNPJ = this.parametroService.getConfigLgpdcpfcnpj();
        ConfigRestricao configRestricao = this.restricaoService.getConfigRestricao();
        Page processos = this.processoPesquisaService.listarProcessosVencidos(configRestricao.getUsuario().getId());
        Boolean isOrdemCrescenteAnexo = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_CRESCENTE_ANEXO.getCodigo());
        Long quantidadeDiasAvisoAVencer = this.parametroService.getParamValueAsLong(ParametroEnum.QTD_DIAS_AVENCER_MP.getCodigo());
        return ResponseEntity.ok().body((Object)processos.map(processo -> new ProcessoEnxutoDTOConverter().to(processo, configLGPDCPFCNPJ, this.restricaoService.permiteAcessoAoProcesso(configRestricao, processo), isOrdemCrescenteAnexo, quantidadeDiasAvisoAVencer)));
    }

    @GetMapping(value={"/lista-a-vencer"})
    public ResponseEntity<Page<ProcessoEnxutoDTO>> listarProcessosAVencer() {
        ConfigLGPDCPFCNPJ configLGPDCPFCNPJ = this.parametroService.getConfigLgpdcpfcnpj();
        ConfigRestricao configRestricao = this.restricaoService.getConfigRestricao();
        Page processos = this.processoPesquisaService.listarProcessosAVencer(configRestricao.getUsuario().getId());
        Boolean isOrdemCrescenteAnexo = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_CRESCENTE_ANEXO.getCodigo());
        Long quantidadeDiasAvisoAVencer = this.parametroService.getParamValueAsLong(ParametroEnum.QTD_DIAS_AVENCER_MP.getCodigo());
        return ResponseEntity.ok().body((Object)processos.map(processo -> new ProcessoEnxutoDTOConverter().to(processo, configLGPDCPFCNPJ, this.restricaoService.permiteAcessoAoProcesso(configRestricao, processo), isOrdemCrescenteAnexo, quantidadeDiasAvisoAVencer)));
    }

    @GetMapping(value={"/lista-dentro-prazo"})
    public ResponseEntity<Page<ProcessoEnxutoDTO>> listarProcessosDentroDoPrazo() {
        ConfigLGPDCPFCNPJ configLGPDCPFCNPJ = this.parametroService.getConfigLgpdcpfcnpj();
        ConfigRestricao configRestricao = this.restricaoService.getConfigRestricao();
        Page processos = this.processoPesquisaService.listarProcessosDentroDoPrazo(configRestricao.getUsuario().getId());
        Boolean isOrdemCrescenteAnexo = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_CRESCENTE_ANEXO.getCodigo());
        Long quantidadeDiasAvisoAVencer = this.parametroService.getParamValueAsLong(ParametroEnum.QTD_DIAS_AVENCER_MP.getCodigo());
        return ResponseEntity.ok().body((Object)processos.map(processo -> new ProcessoEnxutoDTOConverter().to(processo, configLGPDCPFCNPJ, this.restricaoService.permiteAcessoAoProcesso(configRestricao, processo), isOrdemCrescenteAnexo, quantidadeDiasAvisoAVencer)));
    }

    @GetMapping(value={"/receberprocesso"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<List<ProcessoDTO>> getProcessosReceber(PesquisaMultiplosProcessosParams params) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.ENCAMINHADO});
        List processos = this.processoPesquisaService.getProcessosByFuncao(auth.getName(), params.getTipo(), params.getNumero(), params.getAno(), (Set)funcoes);
        this.processoValidacaoService.validarRecebimentoProcesso(processos);
        return ResponseEntity.ok().body((Object)this.collectionToDTO(processos));
    }

    @GetMapping(value={"/encaminharprocesso"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<List<ProcessoDTO>> getProcessosEncaminhar(PesquisaMultiplosProcessosParams params) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.RECEBIDO});
        List processos = this.processoPesquisaService.getProcessosByFuncao(auth.getName(), params.getTipo(), params.getNumero(), params.getAno(), (Set)funcoes);
        this.processoValidacaoService.validarEncaminhamentoProcesso(processos);
        return ResponseEntity.ok().body((Object)this.collectionToDTO(processos));
    }

    @GetMapping(value={"/arquivarprocesso"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<List<ProcessoEnxutoDTO>> getProcessosArquivar(Pageable pageable, PesquisaMultiplosProcessosParams params) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        HashSet funcoes = Sets.newHashSet((Object[])new Funcao[]{Funcao.ABERTO, Funcao.RECEBIDO, Funcao.ENCAMINHADO});
        List processos = this.processoPesquisaService.getProcessosByFuncao(auth.getName(), params.getTipo(), params.getNumero(), params.getAno(), (Set)funcoes);
        ConfigLGPDCPFCNPJ configLGPDCPFCNPJ = this.parametroService.getConfigLgpdcpfcnpj();
        ConfigRestricao configRestricao = this.restricaoService.getConfigRestricao();
        this.processoValidacaoService.validarArquivamentoProcesso(processos);
        Boolean isOrdemCrescenteAnexo = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_CRESCENTE_ANEXO.getCodigo());
        Long quantidadeDiasAvisoAVencer = this.parametroService.getParamValueAsLong(ParametroEnum.QTD_DIAS_AVENCER_MP.getCodigo());
        return ResponseEntity.ok().body(processos.stream().map(processo -> new ProcessoEnxutoDTOConverter().to(processo, configLGPDCPFCNPJ, this.restricaoService.permiteAcessoAoProcesso(configRestricao, processo), isOrdemCrescenteAnexo, quantidadeDiasAvisoAVencer)).collect(Collectors.toList()));
    }

    @GetMapping(value={"/pesquisarprocesso"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<ProcessoDTO> getProcesso(PesquisaProcessoParams params) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Entidade entidade = new Entidade(params.getEntidade());
        Processo processo = this.processoPesquisaService.getProcessoPermissaoLocal(entidade, auth.getName(), params.getTipo(), params.getNumero(), params.getAno());
        return Optional.ofNullable(processo).map(arg_0 -> ((DTOConverter)this.getConverter()).to(arg_0)).map(ResponseEntity::ok).orElseThrow(() -> RestException.notFound((String)"Processo n\u00e3o encontrado ou o usu\u00e1rio n\u00e3o possui permiss\u00e3o no local para visualizar processos sigilosos."));
    }

    @PostMapping(value={"/geracorrecaofluxo"})
    public ResponseEntity<ProcessoDTO> geraCorrecaoFluxo(@RequestBody TramiteProcessosWrapper wrapper) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        wrapper.getProcessos().forEach(p -> {
            Processo processo = this.processoPesquisaService.loadProcesso(Entidade.of((Long)p.getEntidade().getId()), p.getTipo().getId(), p.getNumero(), p.getAno());
            this.correcaoFluxoservice.geraCorrecaoFluxo(processo, authentication.getName(), wrapper.getParecer());
        });
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/geracorrecaofluxo/{lote}"})
    public ResponseEntity<Void> geraCorrecaoFluxoPorLote(@PathVariable(value="lote") Long lote, @RequestBody TramiteProcessosWrapper dto) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        this.processoPesquisaService.findProcessoByTramiteLotePorUltimoTramite(lote).forEach(p -> this.correcaoFluxoservice.geraCorrecaoFluxo(p, authentication.getName(), dto.getParecer()));
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/lote/{lote}"})
    public ResponseEntity<List<ProcessoDTO>> buscarProcessosPorLote(@PathVariable(value="lote") Long lote) {
        List processoByTramiteLotePorUltimoTramite = this.processoPesquisaService.findProcessoByTramiteLotePorUltimoTramite(lote).stream().map(arg_0 -> ((DTOConverter)this.getConverter()).to(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok().body(processoByTramiteLotePorUltimoTramite);
    }

    @GetMapping(value={"/pessoa/{pessoa}"})
    public ResponseEntity<Page<ProcessoEnxutoDTO>> findProcessoByPessoa(Pageable pageable, @PathVariable Long pessoa) {
        Page processos = this.processoPesquisaService.findByPessoaIdOrderByDataProcessoDesc(pessoa, pageable);
        ConfigLGPDCPFCNPJ configLGPDCPFCNPJ = this.parametroService.getConfigLgpdcpfcnpj();
        ConfigRestricao configRestricao = this.restricaoService.getConfigRestricao();
        Boolean isOrdemCrescenteAnexo = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_CRESCENTE_ANEXO.getCodigo());
        Long quantidadeDiasAvisoAVencer = this.parametroService.getParamValueAsLong(ParametroEnum.QTD_DIAS_AVENCER_MP.getCodigo());
        return ResponseEntity.ok().body((Object)processos.map(processo -> new ProcessoEnxutoDTOConverter().to(processo, configLGPDCPFCNPJ, this.restricaoService.permiteAcessoAoProcesso(configRestricao, processo), isOrdemCrescenteAnexo, quantidadeDiasAvisoAVencer)));
    }

    @PostMapping(value={"/pessoa/enviar-lista-processo-por-email/{pessoa}"})
    public ResponseEntity<Void> enviarListaProcessoPorEmail(@PathVariable Long pessoa) {
        Page processos = this.processoPesquisaService.findByPessoaIdOrderByDataProcessoDesc(pessoa, null);
        if (processos.getContent().isEmpty()) {
            throw new EloValidationException("N\u00e3o foi encontrado nenhum processo.");
        }
        this.processoService.enviarListaProcessoPorEmail(processos.getContent());
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/pesquisa-processo-assunto"})
    public ResponseEntity<List<ProcessoPK>> pesquisaProcessoAssunto(@RequestParam(value="idAssunto", required=true) Long idAssunto, @RequestParam(value="idPessoa", required=true) Long idPessoa, @RequestParam(value="dataProcessoInicio", required=false) LocalDate dataProcesoInicio, @RequestParam(value="dataProcessoFim", required=false) LocalDate dataProcesoFim) {
        LocalDate dataIni = Optional.ofNullable(dataProcesoInicio).orElse(LocalDate.now().minusMonths(QTD_MESES));
        LocalDate dataFim = Optional.ofNullable(dataProcesoFim).orElse(LocalDate.now());
        List idProcessos = this.processoPesquisaService.findPKProcessoByAssuntoAndPessoaAndPeriodoDataProcesso(idAssunto, idPessoa, dataIni, dataFim);
        return ResponseEntity.ok().body((Object)idProcessos);
    }

    @GetMapping(value={"/quantidade-processos-assunto"})
    public ResponseEntity<List<ProcessoAssuntoDTO>> quantidadeProcessoAssunto(@RequestParam(value="ano", required=false) Long ano, @RequestParam(value="entidade", required=false) Long entidade) {
        return ResponseEntity.ok((Object)this.processoService.findQuantidadeProcessosPorAssunto(entidade, ano));
    }

    @GetMapping(value={"/codigo-barras/{pkConcatenada}"})
    public ResponseEntity<ProcessoDTO> findProcessoByCodigoDeBarras(@PathVariable(value="pkConcatenada") String pkConcatenada) {
        return ResponseEntity.ok((Object)this.processoService.findProcessoByNumeroAnoTipoConcat(pkConcatenada));
    }

    @GetMapping(value={"/history"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<List<RevisionRecord>> findAllHistoryProcesso(PesquisaProcessoParams params) {
        Entidade entidade = Entidade.of((Long)params.getEntidade());
        TipoProcesso tipoProcesso = (TipoProcesso)this.tipoProcessoRepository.findOne((Object)params.getTipo());
        ProcessoPK pk = ProcessoPK.of((Entidade)entidade, (TipoProcesso)tipoProcesso, (Long)params.getNumero(), (Long)params.getAno());
        return ResponseEntity.ok((Object)this.reader.findHistory(Processo.class, (Serializable)pk));
    }

    @PostMapping(value={"/contagem-processos"})
    public ResponseEntity<ProcessoContagemMesAnoDTO> relatorioContagemPorMesEAno(@RequestBody RelatorioContagemMesAnoParams params) {
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        params.setIdEntidade(entidade.getId());
        return ResponseEntity.ok((Object)this.processoService.relatorioContagemPorMesEAno(params));
    }

    @PutMapping(value={"/alterar-caixa"})
    public ResponseEntity<TramiteDTO> trocarCaixa(@RequestParam(value="tipoProcesso") Long tipoProcesso, @RequestParam(value="numeroProcesso") Long numeroProcesso, @RequestParam(value="anoProcesso") Long anoProcesso, @RequestParam(value="codigoCaixa") Long codigoCaixa, @RequestParam(value="anoCaixa") Long anoCaixa, @RequestParam(value="entidadeProcesso") Long entidadeProcesso) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Entidade entidade = Objects.nonNull(entidadeProcesso) ? Entidade.of((Long)entidadeProcesso) : RequestHeaderHelper.getEntidadeContextHolder();
        ProcessoPK id = this.processoPesquisaService.loadPkById(tipoProcesso, numeroProcesso, anoProcesso, entidade);
        Processo processo = (Processo)this.processoService.findOne((Serializable)id);
        CaixaPK caixaPK = CaixaPK.of((Long)codigoCaixa, (Long)anoCaixa);
        Caixa novaCaixa = (Caixa)this.caixaService.findOne((Serializable)caixaPK);
        Tramite ultimoTramite = (Tramite)processo.getUltimoTramite().orElseThrow(() -> new RegistroNaoEncontradoException(String.format("Ultimo tramite para o processo %s, n\u00e3o foi encontrado.", processo.getId().getNumero())));
        LocalDTO local = new LocalDTO();
        local.setEntidade(new EntidadeDTO(entidade.getId()));
        local.setId(ultimoTramite.getLocal().getId().getId());
        SituacaoDTO situacao = new SituacaoDTO(ultimoTramite.getSituacao().getId(), ultimoTramite.getSituacao().getDescricao(), ultimoTramite.getSituacao().getArquivamento(), ultimoTramite.getSituacao().getPagamentoPendente(), ultimoTramite.getSituacao().getAtiva());
        CaixaDTO caixa = new CaixaDTO(novaCaixa.getId().getCodigo(), novaCaixa.getId().getAno(), novaCaixa.getDescricao());
        ProcessoDTO processoDTO = (ProcessoDTO)this.getConverter().to((EloEntity)processo);
        TramiteProcessosWrapper wrapper = new TramiteProcessosWrapper();
        wrapper.setFuncao(Funcao.ARQUIVADO);
        String descricaoUltimaCaixa = ultimoTramite.getCaixa() != null ? ultimoTramite.getCaixa().getDescricao() : "Indefinido";
        wrapper.setParecer(String.format("Altera\u00e7\u00e3o de caixa. De: %s -> Para: %s", descricaoUltimaCaixa, novaCaixa.getDescricao()));
        wrapper.setSituacao(situacao);
        wrapper.setCaixa(caixa);
        wrapper.setQuantidadeFolhas(ultimoTramite.getQuantidadeFolhas());
        wrapper.setLote(ultimoTramite.getLote());
        wrapper.setNotaPrivada(ultimoTramite.getNotaPrivada());
        wrapper.setLocal(local);
        wrapper.getProcessos().add(processoDTO);
        TramiteAlterarCaixaStrategy strategy = new TramiteAlterarCaixaStrategy(entidade, this.mapperProtocolo, this.parametroService);
        Processo processoSalvo = (Processo)this.processoService.tramitar(Collections.singletonList(processo), wrapper, entidade, authentication.getName(), (TramiteBusinessStrategy)strategy).get(0);
        ProcessoDTO processoSalvoDto = (ProcessoDTO)this.getConverter().to((EloEntity)processoSalvo);
        TramiteDTO tramiteDTO = (TramiteDTO)processoSalvoDto.getUltimoTramite().orElseThrow(() -> new RegistroNaoEncontradoException(String.format("Ultimo tramite para o processo %s, n\u00e3o foi encontrado.", processoSalvoDto.getNumero())));
        tramiteDTO.setNomeUsuario(authentication.getName());
        tramiteDTO.setQuantidadeDiasLocal(TramiteDTO.getDiasParadoSetor((List)processoDTO.getTramites(), (TramiteDTO)tramiteDTO));
        return ResponseEntity.ok((Object)tramiteDTO);
    }

    @PutMapping(value={"/alterar-paralisado"})
    public ResponseEntity<Void> alterarStatusParalisado(@RequestParam(value="tipoProcesso") Long tipoProcesso, @RequestParam(value="numeroProcesso") Long numeroProcesso, @RequestParam(value="anoProcesso") Long anoProcesso, @RequestParam(value="entidadeProcesso") Long entidadeProcesso) {
        Entidade entidade = Objects.nonNull(entidadeProcesso) ? new Entidade(entidadeProcesso) : RequestHeaderHelper.getEntidadeContextHolder();
        ProcessoPK id = this.processoPesquisaService.loadPkById(tipoProcesso, numeroProcesso, anoProcesso, entidade);
        Processo processo = (Processo)this.processoService.findOne((Serializable)id);
        this.processoService.alterarStatusParalisado(processo);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/usuario"})
    public ResponseEntity<Page<ProcessoDTO>> findProcessosByUsuario(@RequestParam(value="cpfCnpj", defaultValue="", required=false) String cpfCnpj, @RequestParam(value="search", defaultValue="", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.processoService.findProcessosByUsuario(Optional.ofNullable(cpfCnpj).orElse(SecurityUtils.getUsername()), search, pageable));
    }

    @PutMapping(value={"/avaliar"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<Void> avaliarProcesso(@RequestParam(value="cpfCnpj", defaultValue="", required=false) String cpfCnpj, @RequestBody AvaliacaoProcessoDTO avaliacaoProcessoDTO, PesquisaProcessoParams params) {
        Processo processo = this.processoPesquisaService.findProcessoByPkAndUsuario(params.getAno(), params.getTipo(), params.getNumero(), params.getEntidade(), Optional.ofNullable(cpfCnpj).orElse(SecurityUtils.getUsername()));
        if (processo == null) {
            throw RestException.notFound((String)"Processo n\u00e3o existe ou voc\u00ea n\u00e3o possui permiss\u00e3o para avaliar este processo.");
        }
        this.processoService.avaliarProcesso(processo, avaliacaoProcessoDTO);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/resumo"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<ProcessoDTO> findProcessoByPkAndUsuario(@RequestParam(value="cpfCnpj", defaultValue="", required=false) String cpfCnpj, PesquisaProcessoParams params) {
        Processo processo = this.processoPesquisaService.findProcessoByPkAndUsuario(params.getAno(), params.getTipo(), params.getNumero(), params.getEntidade(), Optional.ofNullable(cpfCnpj).orElse(SecurityUtils.getUsername()));
        return Optional.ofNullable(processo).map(arg_0 -> ((DTOConverter)this.getConverter()).to(arg_0)).map(ResponseEntity::ok).orElseThrow(() -> RestException.notFound((String)"Processo n\u00e3o encontrado para este CPF."));
    }

    @PutMapping(value={"/reabrir-processo"}, params={"entidade", "tipo", "ano", "numero"})
    public ResponseEntity<Void> reabrirProcessoRequerente(@RequestBody String parecer, @RequestParam(value="cpfCnpj", defaultValue="", required=false) String cpfCnpj, PesquisaProcessoParams params) {
        ProcessoPK id = new ProcessoPK();
        id.setEntidade(Entidade.of((Long)params.getEntidade()));
        id.setTipo(TipoProcesso.of((Long)params.getTipo()));
        id.setNumero(params.getNumero());
        id.setAno(params.getAno());
        Processo processo = this.processoPesquisaService.findProcessoByPkAndUsuario(params.getAno(), params.getTipo(), params.getNumero(), params.getEntidade(), Optional.ofNullable(cpfCnpj).orElse(SecurityUtils.getUsername()));
        if (Objects.isNull(processo)) {
            throw new RestException(HttpStatus.NOT_FOUND, String.format("Processo de n\u00famero %d/%d n\u00e3o foi encontrado para o usu\u00e1rio.", params.getNumero(), params.getAno()));
        }
        this.processoService.reabrirProcessoRequerente(processo, parecer);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/fechar-reabrir-processo"}, params={"tipo", "ano", "numero", "entidade"})
    public ResponseEntity<Void> fecharReabrirProcesso(PesquisaProcessoParams params) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Entidade entidade = new Entidade(params.getEntidade());
        Processo processo = this.processoPesquisaService.loadProcesso(entidade, params.getTipo(), params.getNumero(), params.getAno());
        this.processoService.fecharReabrirProcesso(processo, authentication);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/lista-alteracao-requerimento"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<List<RequerimentoObservacaoProcessoAuditDTO>> listaAlteracaoRequerimento(Long tipo, Long numero, Long ano, Long entidade) {
        return ResponseEntity.ok((Object)this.processoService.listaAlteracaoRequerimento(numero, tipo, ano, entidade));
    }

    @GetMapping(value={"/lista-alteracao-observacao"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<List<RequerimentoObservacaoProcessoAuditDTO>> listaAlteracaoObservacao(Long tipo, Long numero, Long ano, Long entidade) {
        return ResponseEntity.ok((Object)this.processoService.listaAlteracaoObservacao(numero, tipo, ano, entidade));
    }

    @GetMapping(value={"/portal"})
    public ResponseEntity<Page<ProcessoDTO>> findAllPortal(@RequestParam(value="search", required=false, defaultValue="") String search, Pageable pageable) {
        Page processos = this.processoPesquisaService.findAllPortal(search, pageable);
        Boolean isMaskCPF = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CPF_LGPD.getCodigo());
        Boolean isMaskCNPJ = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CNPJ_LGPD.getCodigo());
        Boolean isMaskUser = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_USUARIO_COM_MASCARA_COM_CPF_LGPD.getCodigo());
        Boolean isOrdemCrescenteAnexo = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_CRESCENTE_ANEXO.getCodigo());
        Boolean isOrdemDecrescenteApenasCampoCalculado = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_DECRESCENTE_ANEXO.getCodigo());
        List result = processos.stream().map(processo -> new ProcessoDTOConverter().to(processo, isMaskCPF, isMaskCNPJ, isMaskUser, isOrdemCrescenteAnexo, isOrdemDecrescenteApenasCampoCalculado)).collect(Collectors.toList());
        return ResponseEntity.ok().body((Object)new PageImpl(result, pageable, processos.getTotalElements()));
    }

    @GetMapping(value={"/lista-encaminhamento-paralisado"})
    public ResponseEntity<Page<ProcessoDTO>> listarProcessosEncaminharParalisado(Authentication authentication, Pageable pageable, TramitacaoListagemParams params) {
        params.setUsuario(authentication.getName());
        params.setPageable(pageable);
        Page processos = this.processoPesquisaService.listarProcessosEncaminhar(params, Boolean.FALSE, Boolean.TRUE);
        return ResponseEntity.ok().body((Object)processos.map(arg_0 -> ((DTOConverter)this.getConverter()).to(arg_0)));
    }

    @PutMapping(value={"/atualizar-assunto"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<Void> atualizarAssunto(@RequestBody AssuntoDTO dto, PesquisaProcessoParams params) {
        this.processoService.atualizarAssunto(params, dto);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/alterar-tramite-entre-entidades"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<Void> alterarTramitarEntreEntidades(PesquisaProcessoParams params) {
        this.processoService.alterarTramitarEntreEntidades(params);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/buscar-processo-arquivado"})
    public ResponseEntity<Page<ProcessoDTO>> findAllProcessoArquivado(@RequestParam(value="search", required=false) String search, Pageable pageable, HttpServletRequest request) {
        Page processosPage = this.processoPesquisaService.findByRsql(search, pageable);
        Page dtosPage = processosPage.map(arg_0 -> ((ProtocoloMapper)this.mapperProtocolo).toProcessoDTO(arg_0));
        return ResponseEntity.ok((Object)dtosPage);
    }

    @GetMapping(value={"/lista-encaminhados-usuario"})
    public ResponseEntity<Page<ProcessoEnxutoDTO>> listarProcessosEncaminhadosUsuario(@RequestParam(value="filtrarUsuarioReg", required=false, defaultValue="true") String filtrarUsuarioReg, Pageable pageable, TramitacaoListagemParams params) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            params.setUsuario(authentication.getName());
        }
        params.setPageable(pageable);
        ConfigLGPDCPFCNPJ configLGPDCPFCNPJ = this.parametroService.getConfigLgpdcpfcnpj();
        ConfigRestricao configRestricao = this.restricaoService.getConfigRestricao();
        Page processos = this.processoPesquisaService.listarProcessosEncaminhadosUsuario(params, Boolean.valueOf(filtrarUsuarioReg));
        Boolean isOrdemCrescenteAnexo = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_CRESCENTE_ANEXO.getCodigo());
        Long quantidadeDiasAvisoAVencer = this.parametroService.getParamValueAsLong(ParametroEnum.QTD_DIAS_AVENCER_MP.getCodigo());
        return ResponseEntity.ok().body((Object)processos.map(processo -> new ProcessoEnxutoDTOConverter().to(processo, configLGPDCPFCNPJ, this.restricaoService.permiteAcessoAoProcesso(configRestricao, processo), isOrdemCrescenteAnexo, quantidadeDiasAvisoAVencer)));
    }
}

