/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.config.ElotechProperties;
import br.com.elotech.core.metamodel.MetaModel;
import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.core.web.rest.dto.DTOConverter;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.params.TramitacaoListagemParams;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.reportexport.exporter.ReportViewData;
import br.com.elotech.reportexport.exporter.ReportViewModel;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/processos-reports"})
public class ProcessoReportResource
extends BaseResourceDTO<Processo, ProcessoPK, ProcessoDTO> {
    private final ProcessoPesquisaService processoPesquisaService;
    private final ElotechProperties elotechProperties;

    public ProcessoReportResource(ProcessoPesquisaService processoPesquisaService, ElotechProperties elotechProperties) {
        this.processoPesquisaService = processoPesquisaService;
        this.elotechProperties = elotechProperties;
    }

    @GetMapping(value={"/lista-recebimento/report"})
    public ReportViewModel listaRecebimentoReport(@RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="fields") String fields, @RequestParam(value="maximoRegistros") int maximoRegistros, @RequestParam(value="filtrarResponsavelTramite", required=false) boolean filtrarResponsavelTramite, Pageable pageable) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Page resultData = this.processoPesquisaService.listarProcessosReceber(this.buildParams(authentication, search, pageable, maximoRegistros), Boolean.valueOf(filtrarResponsavelTramite)).map(arg_0 -> ((DTOConverter)this.getConverter()).to(arg_0));
        return this.buildReport(fields, resultData, search);
    }

    @GetMapping(value={"/lista-encaminhamento/report"})
    public ReportViewModel listaEncaminhamentoReport(@RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="fields") String fields, @RequestParam(value="maximoRegistros") int maximoRegistros, Pageable pageable) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Page resultData = this.processoPesquisaService.listarProcessosEncaminhar(this.buildParams(authentication, search, pageable, maximoRegistros), Boolean.valueOf(false), Boolean.valueOf(false)).map(arg_0 -> ((DTOConverter)this.getConverter()).to(arg_0));
        return this.buildReport(fields, resultData, search);
    }

    private ReportViewModel buildReport(String fields, Page<ProcessoDTO> data, String search) {
        return ReportViewData.builder((MetaModel)this.getMetaModel()).withFields(fields, this.elotechProperties.getReport().getMaximoColunas()).withPage(data).withSearchFilter(search).build().toReportModelAndView();
    }

    private TramitacaoListagemParams buildParams(Authentication authentication, String search, Pageable pageable, int maximoRegistros) {
        TramitacaoListagemParams params = new TramitacaoListagemParams();
        params.setUsuario(authentication.getName());
        params.setPageable((Pageable)PageRequest.of((int)pageable.getPageNumber(), (int)maximoRegistros, (Sort)pageable.getSort()));
        params.setSearch(search);
        return params;
    }
}

