/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.protocolo.converter.ProcessoObservadorExternoDTOConverter;
import br.com.elotech.protocolo.domain.ProcessoObservadorExterno;
import br.com.elotech.protocolo.dto.ProcessoObservadorExternoDTO;
import br.com.elotech.protocolo.service.ProcessoObservadorExternoService;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/processos-observadores-externos"})
public class ProcessoObservadorExternoResource {
    private final ProcessoObservadorExternoService service;

    public ProcessoObservadorExternoResource(ProcessoObservadorExternoService service) {
        this.service = service;
    }

    @PostMapping(value={"/{id}/send-email"})
    public ResponseEntity<Void> sendEmail(@PathVariable(value="id") UUID id) throws ExecutionException, InterruptedException, TimeoutException {
        this.service.sendEmail(id);
        return ResponseEntity.ok().build();
    }

    @PostMapping
    public ResponseEntity<ProcessoObservadorExternoDTO> save(@RequestBody ProcessoObservadorExternoDTO dto, Authentication authentication) {
        ProcessoObservadorExternoDTOConverter converter = new ProcessoObservadorExternoDTOConverter();
        ProcessoObservadorExterno entity = (ProcessoObservadorExterno)this.service.save((EloEntity)converter.from(dto), authentication);
        return ResponseEntity.ok((Object)converter.to(entity));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable(value="id") UUID id, Authentication authentication) {
        ProcessoObservadorExterno entity = (ProcessoObservadorExterno)this.service.findOne((Serializable)id);
        this.service.delete((EloEntity)entity, authentication);
        return ResponseEntity.ok().build();
    }
}

