/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.protocolo.dto.ProcessoInteressadoDTO;
import br.com.elotech.protocolo.dto.params.ProcessoInteressadoParams;
import br.com.elotech.protocolo.service.ProcessoInteressadoService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/processos-interessados"})
public class ProcessoInteressadoResource {
    private final ProcessoInteressadoService service;

    @GetMapping(value={"/by-processo"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<List<ProcessoInteressadoDTO>> findByProcesso(ProcessoInteressadoParams params) {
        return ResponseEntity.ok((Object)this.service.findByProcesso(params));
    }

    @PostMapping(params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<ProcessoInteressadoDTO> create(@RequestParam(value="tipo") Long tipo, @RequestParam(value="ano") Long ano, @RequestParam(value="numero") Long numero, @RequestParam(value="entidade") Long entidade, @RequestBody ProcessoInteressadoDTO dto) {
        return ResponseEntity.ok((Object)this.service.create(ProcessoInteressadoParams.of((Long)tipo, (Long)ano, (Long)numero, (Long)entidade), dto));
    }

    @DeleteMapping(params={"tipo", "numero", "ano", "codigo", "entidade"})
    public ResponseEntity<Void> deleteById(ProcessoInteressadoParams params) {
        this.service.deleteById(params);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public ProcessoInteressadoResource(ProcessoInteressadoService service) {
        this.service = service;
    }
}

