/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoIntegracao;
import br.com.elotech.protocolo.dto.ProcessoPKSimplesDTO;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.service.ProcessoIntegracaoService;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/integracao-processos"})
public class ProcessoIntegracaoResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoIntegracaoResource.class);
    private final ProcessoIntegracaoService service;
    private final ProcessoPesquisaService processoPesquisaService;

    public ProcessoIntegracaoResource(ProcessoIntegracaoService service, ProcessoPesquisaService processoPesquisaService) {
        this.service = service;
        this.processoPesquisaService = processoPesquisaService;
    }

    @GetMapping
    public ResponseEntity<List<ProcessoPKSimplesDTO>> findAllProcessosNaoIntegrados() {
        return ResponseEntity.ok((Object)this.service.findAllProcessosNaoIntegrados());
    }

    @PostMapping(value={"/reenviar"})
    public ResponseEntity<Void> reenviarProcessos() {
        Set integracoes = this.service.getStatusIntegracaoEnums();
        if (integracoes.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        log.info("Reenviando processos n\u00e3o integrados");
        List processosNaoIntegrados = this.service.findAllPendenteIntegrado(integracoes);
        if (processosNaoIntegrados.isEmpty()) {
            log.info("Nenhum processo para ser integrado");
            return ResponseEntity.notFound().build();
        }
        for (ProcessoIntegracao processoIntegracao : processosNaoIntegrados) {
            this.service.enviarProcessoIntegracao(processoIntegracao);
        }
        log.info("Finalizada integra\u00e7\u00e3o de processos n\u00e3o integrados");
        return ResponseEntity.ok().build();
    }

    @PostMapping(params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<Void> integrarProcessoAise(PesquisaProcessoParams params) {
        Processo processo = this.processoPesquisaService.loadProcesso(Entidade.of((Long)params.getEntidade()), params.getTipo(), params.getNumero(), params.getAno());
        this.service.salvarProcessoIntegracao(processo);
        return ResponseEntity.ok().build();
    }
}

