/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.core.web.rest.dto.DTOConverter;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoFavorito;
import br.com.elotech.protocolo.domain.ProcessoFavoritoPK;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.domain.Usuario;
import br.com.elotech.protocolo.dto.ProcessoFavoritoDTO;
import br.com.elotech.protocolo.service.ProcessoFavoritoService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/processos-favoritos"})
public class ProcessoFavoritoResource
extends BaseResourceDTO<ProcessoFavorito, ProcessoFavoritoPK, ProcessoFavoritoDTO> {
    public ProcessoFavoritoService getService() {
        return (ProcessoFavoritoService)super.getService();
    }

    @GetMapping(value={"/usuario"})
    public ResponseEntity<List<ProcessoFavoritoDTO>> findAllByUsuario() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return ResponseEntity.ok(this.getService().findAllByUsuario(auth.getName()).stream().map(arg_0 -> ((DTOConverter)this.getConverter()).to(arg_0)).collect(Collectors.toList()));
    }

    @PostMapping
    public ResponseEntity<ProcessoFavoritoDTO> save(@RequestBody ProcessoFavoritoDTO dto, Authentication authentication, UriComponentsBuilder builder, HttpServletRequest request) {
        return super.save((Object)dto, authentication, builder, request);
    }

    @GetMapping(value={"/exists"}, params={"numero", "ano", "tipo", "entidade", "usuario"})
    public ResponseEntity<Boolean> existsById(@RequestParam(value="numero") Long numero, @RequestParam(value="ano") Long ano, @RequestParam(value="tipo") Long tipo, @RequestParam(value="entidade") Long entidade, @RequestParam(value="usuario") String usuario) {
        if (usuario.isEmpty()) {
            return ResponseEntity.ok((Object)Boolean.FALSE);
        }
        Processo processo = new Processo();
        processo.setId(ProcessoPK.of((Entidade)Entidade.of((Long)entidade), (TipoProcesso)TipoProcesso.of((Long)tipo), (Long)numero, (Long)ano));
        Usuario user = new Usuario();
        user.setId(usuario);
        return ResponseEntity.ok((Object)this.getService().existsById(ProcessoFavoritoPK.of((Processo)processo, (Usuario)user)));
    }

    @DeleteMapping(params={"numero", "ano", "tipo", "entidade", "usuario"})
    public ResponseEntity<ProcessoFavoritoDTO> remove(@RequestParam(value="numero") Long numero, @RequestParam(value="ano") Long ano, @RequestParam(value="tipo") Long tipo, @RequestParam(value="entidade") Long entidade, @RequestParam(value="usuario") String usuario) {
        Processo processo = new Processo();
        processo.setId(ProcessoPK.of((Entidade)Entidade.of((Long)entidade), (TipoProcesso)TipoProcesso.of((Long)tipo), (Long)numero, (Long)ano));
        Usuario user = new Usuario();
        user.setId(usuario);
        ProcessoFavoritoPK id = ProcessoFavoritoPK.of((Processo)processo, (Usuario)user);
        super.remove((Serializable)id);
        return ResponseEntity.ok((Object)((ProcessoFavoritoDTO)this.getConverter().to((EloEntity)new ProcessoFavorito(id))));
    }
}

