/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Parametro;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.ProcessoExternoConfigDTO;
import br.com.elotech.protocolo.dto.TipoProcessoDTO;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.ProcessoArquivoService;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.protocolo.service.ProcessoService;
import br.com.elotech.protocolo.service.ProtocoloConfigService;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/processosExterno"})
public class ProcessoExternoResource
extends BaseResourceDTO<Processo, ProcessoPK, ProcessoDTO> {
    private static final String USER_EXTERNO = "USER_EXTERNO";
    private final ProcessoService processoService;
    private final ParametroService parametroService;
    private final EntidadeService entidadeService;
    private final ProtocoloMapper mapper;
    private final ProcessoPesquisaService processoPesquisaService;
    private final ProcessoArquivoService processoArquivoService;
    private final ProtocoloConfigService protocoloConfigService;

    public ProcessoExternoResource(ProcessoService processoService, ParametroService parametroService, EntidadeService entidadeService, ProtocoloMapper mapper, ProcessoPesquisaService processoPesquisaService, ProcessoArquivoService processoArquivoService, ProtocoloConfigService protocoloConfigService) {
        this.processoService = processoService;
        this.parametroService = parametroService;
        this.entidadeService = entidadeService;
        this.mapper = mapper;
        this.processoPesquisaService = processoPesquisaService;
        this.processoArquivoService = processoArquivoService;
        this.protocoloConfigService = protocoloConfigService;
    }

    @PostMapping
    public ProcessoDTO save(@RequestBody ProcessoDTO processo) {
        return this.mapper.toProcessoDTO(this.processoService.saveProcessoExterno(processo, null));
    }

    @PostMapping(value={"/{idEntidade}"})
    public ProcessoDTO saveByEntidade(@PathVariable(value="idEntidade") Long idEntidade, @RequestBody ProcessoDTO processo) {
        return this.mapper.toProcessoDTO(this.processoService.saveProcessoExterno(processo, idEntidade));
    }

    @GetMapping(value={"/config", "/{idEntidade}/config"})
    public ProcessoExternoConfigDTO getConfig(@PathVariable(value="idEntidade", required=false) Long idEntidade) {
        Long exercicioAtual;
        Parametro parametroEntidadeProcessoExterno;
        boolean isParametroEntidadeProcessoExternoConfigurado;
        Entidade entidadePadrao = this.entidadeService.getEntidadeAtual();
        if (Objects.nonNull(idEntidade)) {
            entidadePadrao = (Entidade)this.entidadeService.findOne((Serializable)idEntidade);
        }
        boolean bl = isParametroEntidadeProcessoExternoConfigurado = Objects.nonNull(parametroEntidadeProcessoExterno = this.parametroService.getByEntidadeAndExercicioAndCodigo(entidadePadrao, exercicioAtual = Long.valueOf(LocalDate.now().getYear()), ParametroEnum.PROCESSO_EXTERNO_ENTIDADE.getCodigo())) && !StringUtils.isBlank((CharSequence)parametroEntidadeProcessoExterno.getValor());
        if (isParametroEntidadeProcessoExternoConfigurado) {
            Entidade entidadeProcessoExterno = (Entidade)this.entidadeService.findOne((Serializable)Long.valueOf(Long.parseLong(parametroEntidadeProcessoExterno.getValor())));
            Boolean isEmailObrigatorio = this.parametroService.getParamValueAsBoolean(ParametroEnum.PROCESSO_EXTERNO_EMAIL_OBRIGATORIO.getCodigo(), entidadeProcessoExterno.getId(), exercicioAtual);
            Boolean isTelefoneObrigatorio = this.parametroService.getParamValueAsBoolean(ParametroEnum.PROCESSO_EXTERNO_TELEFONE_OBRIGATORIO.getCodigo(), entidadeProcessoExterno.getId(), exercicioAtual);
            Boolean bloqueiaAberturaAnonimaOuvidoria = this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEAR_ABERTURA_ANONIMA_OUVIDORIA.getCodigo(), entidadeProcessoExterno.getId(), exercicioAtual);
            String mensagemAvisoProcessoOuvidoria = this.parametroService.getParamValueAsString(ParametroEnum.MENSAGEM_AVISO_PROCESSOS_OUVIDORIA.getCodigo(), entidadeProcessoExterno.getId(), exercicioAtual);
            Long tamanhoMaximoArquivos = this.parametroService.getParamValueAsLong(ParametroEnum.PROCESSO_EXTERNO_TAMANHO_MAXIMO_ARQUIVO.getCodigo(), entidadeProcessoExterno.getId(), exercicioAtual);
            Boolean bloqueiaAberturaAnonimaAberturaExterna = this.parametroService.getParamValueAsBoolean(ParametroEnum.BLOQUEAR_ABERTURA_ANONIMA_ABERTURA_EXTERNA.getCodigo(), entidadeProcessoExterno.getId(), exercicioAtual);
            Boolean isEnderecoRequired = this.protocoloConfigService.isEnderecoRequired(entidadeProcessoExterno, exercicioAtual);
            return ProcessoExternoConfigDTO.builder().emailIsRequired(isEmailObrigatorio).enderecoIsRequired(isEnderecoRequired).telefoneIsRequired(isTelefoneObrigatorio).tamanhoMaximoAnexos(tamanhoMaximoArquivos).bloqueiaAberturaAnonimaOuvidoria(bloqueiaAberturaAnonimaOuvidoria).bloqueiaAberturaAnonimaAberturaExterna(bloqueiaAberturaAnonimaAberturaExterna).mensagemAvisoProcessosOuvidoria(mensagemAvisoProcessoOuvidoria).build();
        }
        return new ProcessoExternoConfigDTO();
    }

    @PostMapping(value={"/arquivo", "/arquivo/documento/{documento}"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<ProcessoDTO> addArquivo(@RequestParam(value="files") MultipartFile file, @PathVariable(name="documento", required=false) Long documentoId, @RequestParam(value="hasSignatures", required=false) Boolean hasSignatures, PesquisaProcessoParams params) throws IOException, InterruptedException {
        Entidade entidade = (Entidade)this.entidadeService.findOne((Serializable)params.getEntidade());
        if (Objects.isNull(entidade)) {
            throw RestException.notFound((String)"Entidade n\u00e3o localizado.");
        }
        Processo processo = this.processoPesquisaService.loadProcesso(entidade, params.getTipo(), params.getNumero(), params.getAno());
        if (Objects.isNull(processo)) {
            throw RestException.notFound((String)"Processo n\u00e3o localizado.");
        }
        ProcessoDTO processoDTO = this.processoArquivoService.addArquivo(processo, USER_EXTERNO, file, documentoId, Boolean.FALSE, Boolean.FALSE, Boolean.valueOf(false), hasSignatures);
        processoDTO.removeArquivosSigilosos();
        return ResponseEntity.ok((Object)processoDTO);
    }

    @GetMapping(value={"/tipo-padrao"})
    public ResponseEntity<TipoProcessoDTO> getTipoProcessoExternoPadrao() {
        Long idEntidade = this.parametroService.getParamLongEntidadeProcessoExterno();
        Entidade entidade = (Entidade)this.entidadeService.findOne((Serializable)idEntidade);
        return ResponseEntity.ok((Object)this.mapper.toTipoProcessoDTO(this.parametroService.getParamTipoProcessoExterno(entidade)));
    }
}

