/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.protocolo.service.ProcessoService;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;

@RestController
@RequestMapping(value={"/api/processos/email/"})
public class ProcessoEmailResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoEmailResource.class);
    private final ProcessoService processoService;

    @PostMapping(value={"processos-vencidos/{entidade}"})
    public ResponseEntity<Void> enviaEmailProcessosEmAtraso(@PathVariable(value="entidade") Long entidade) {
        log.info("Iniciando envio de emails para processos em atraso para a entidade [{}]", (Object)entidade);
        Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).setAttribute("entidade", (Object)entidade, 0);
        this.processoService.enviaEmailsProcessosAtrasados();
        log.info("Finalizado envio de emails para processos em atraso para a entidade [{}]", (Object)entidade);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public ProcessoEmailResource(ProcessoService processoService) {
        this.processoService = processoService;
    }
}

