/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.dto.ProcessoAvaliacaoDTO;
import br.com.elotech.protocolo.service.ProcessoAvaliacaoService;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/processos/avaliacao"})
public class ProcessoAvaliacaoResource {
    private final ProcessoPesquisaService processoPesquisaService;
    private final ProcessoAvaliacaoService processoAvaliacaoService;

    public ProcessoAvaliacaoResource(ProcessoPesquisaService processoPesquisaService, ProcessoAvaliacaoService processoAvaliacaoService) {
        this.processoPesquisaService = processoPesquisaService;
        this.processoAvaliacaoService = processoAvaliacaoService;
    }

    @PostMapping
    public ResponseEntity<ProcessoAvaliacaoDTO> avaliar(@RequestBody ProcessoAvaliacaoDTO processoAvaliacaoDTO) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        Processo processo = this.processoPesquisaService.loadProcesso(entidade, processoAvaliacaoDTO.getTipo(), processoAvaliacaoDTO.getNumero(), processoAvaliacaoDTO.getAno());
        this.processoAvaliacaoService.avaliarProcesso(authentication.getName(), processo);
        return ResponseEntity.ok((Object)processoAvaliacaoDTO);
    }
}

