/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.TipoProcesso;
import br.com.elotech.protocolo.dto.AssinaturaIntegracaoRequestDTO;
import br.com.elotech.protocolo.dto.PkProcessoDTO;
import br.com.elotech.protocolo.dto.RetornoIntegracaoAssinaturaDTO;
import br.com.elotech.protocolo.enums.TipoIntegracaoEnum;
import br.com.elotech.protocolo.service.ProcessoService;
import br.com.elotech.protocolo.service.assinatura.AssinaturaIntegracaoService;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/processos-assinatura"})
public class ProcessoAssinaturaResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoAssinaturaResource.class);
    private final AssinaturaIntegracaoService assinaturaIntegracaoService;
    private final ProcessoService processoService;

    public ProcessoAssinaturaResource(AssinaturaIntegracaoService assinaturaIntegracaoService, ProcessoService processoService) {
        this.assinaturaIntegracaoService = assinaturaIntegracaoService;
        this.processoService = processoService;
    }

    @PostMapping(value={"/gerar-protocolo-assinatura"})
    public ResponseEntity<RetornoIntegracaoAssinaturaDTO> gerarProcessoAssinatura(@RequestBody AssinaturaIntegracaoRequestDTO assinaturaIntegracaoDTO) {
        log.info("In\u00edcio gera\u00e7\u00e3o de protocolo assinatura Individual  Movimento:{} id:{}", (Object)assinaturaIntegracaoDTO.getTipoIntegracao(), (Object)assinaturaIntegracaoDTO.getId());
        return ResponseEntity.ok((Object)this.assinaturaIntegracaoService.saveProcessoIntegracao(assinaturaIntegracaoDTO));
    }

    @PostMapping(value={"/gerar-protocolo-assinaturas"})
    public ResponseEntity<List<RetornoIntegracaoAssinaturaDTO>> gerarProcessoAssinaturas(@RequestBody List<AssinaturaIntegracaoRequestDTO> assinaturasIntegracaoDTO) {
        log.info("In\u00edcio gera\u00e7\u00e3o de protocolo assinaturas Lote:{}", (Object)assinaturasIntegracaoDTO.size());
        return ResponseEntity.ok((Object)this.assinaturaIntegracaoService.saveProcessoIntegracaoLote(assinaturasIntegracaoDTO));
    }

    @PostMapping(value={"/republicar"})
    public ResponseEntity<Void> republicarProcessoAssinatura() {
        this.assinaturaIntegracaoService.republish();
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/publicar"})
    public ResponseEntity<Void> publicarProcessoAssinatura(@RequestBody PkProcessoDTO pkProcessoDTO, @RequestParam(name="ignorarProcessoArquivo", required=false) Boolean ignorarProcessoArquivo) {
        Optional processo = this.processoService.findById((Serializable)ProcessoPK.of((Entidade)Entidade.of((Long)pkProcessoDTO.getEntidade()), (TipoProcesso)TipoProcesso.of((Long)pkProcessoDTO.getTipo()), (Long)pkProcessoDTO.getNumero(), (Long)pkProcessoDTO.getAno()));
        if (processo.isPresent()) {
            this.assinaturaIntegracaoService.finalizarProcessoAssinatura((Processo)processo.get(), SecurityContextHolder.getContext().getAuthentication().getName());
            if (!Boolean.TRUE.equals(ignorarProcessoArquivo)) {
                ((Processo)processo.get()).getArquivos().forEach(processoArquivo -> this.assinaturaIntegracaoService.publicarAtualizacaoArquivo(processoArquivo, OutboxActions.UPDATED));
            }
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/gerar-processo-fluxo-assinatura"})
    public ResponseEntity<RetornoIntegracaoAssinaturaDTO> gerarProcessoFluxoAssinatura(@RequestBody AssinaturaIntegracaoRequestDTO assinaturaIntegracaoRequestDTO) {
        return ResponseEntity.ok((Object)this.assinaturaIntegracaoService.gerarProcessoFluxoAssinatura(assinaturaIntegracaoRequestDTO));
    }

    @DeleteMapping(value={"/remover-processo/{processoId}"})
    public ResponseEntity<Void> removerProcesso(@PathVariable(value="processoId") UUID id, @RequestParam(value="ignoraAssinaturas", required=false) Boolean ignoraAssinaturas) {
        this.assinaturaIntegracaoService.removerProcesso(id, ignoraAssinaturas);
        return ResponseEntity.noContent().build();
    }

    @DeleteMapping(value={"/remover-arquivos-assinatura/{tipoIntegracaoAssinatura}/{idIntegracaoAssinatura}"})
    public ResponseEntity<Void> removerArquivosAssinatura(@PathVariable(value="tipoIntegracaoAssinatura") TipoIntegracaoEnum tipoIntegracaoAssinatura, @PathVariable(value="idIntegracaoAssinatura") String idIntegracaoAssinatura) {
        this.assinaturaIntegracaoService.removerArquivosAssinatura(tipoIntegracaoAssinatura, idIntegracaoAssinatura);
        return ResponseEntity.noContent().build();
    }
}

