/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.adm.exception.ExportacaoException;
import br.com.elotech.adm.exporter.FileExportExecutorDTO;
import br.com.elotech.adm.exporter.view.AbstractItextPdfView;
import br.com.elotech.adm.utils.HeaderUtils;
import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.protocolo.converter.ProcessoDTOConverter;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoArquivo;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.dto.AnaliseArquivoDTO;
import br.com.elotech.protocolo.dto.ArquivoTemplateDTO;
import br.com.elotech.protocolo.dto.ProcessoArquivoDTO;
import br.com.elotech.protocolo.dto.ProcessoArquivoZipDTO;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.enums.AnaliseArquivoEnum;
import br.com.elotech.protocolo.mail.senders.impl.ProcessoArquivoEmailSender;
import br.com.elotech.protocolo.repository.ProcessoArquivoRepository;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ModeloExporterService;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.ProcessoArquivoService;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.protocolo.utils.ByteMultipartFile;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.filter.ShallowEtagHeaderFilter;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/processos-arquivos"})
public class ProcessoArquivoResource {
    private final ProcessoArquivoService processoArquivoService;
    private final ProcessoPesquisaService processoPesquisaService;
    private final EntidadeService entidadeService;
    private final ProcessoArquivoRepository processoArquivoRepository;
    private final ProcessoArquivoEmailSender processoArquivoEmailSender;
    private final ModeloExporterService modeloExporterService;
    private final ProtocoloMapper protocoloMapper;
    private final ParametroService parametroService;

    public ProcessoArquivoResource(ProcessoArquivoService processoArquivoService, ProcessoPesquisaService processoPesquisaService, EntidadeService entidadeService, ProcessoArquivoRepository processoArquivoRepository, ProcessoArquivoEmailSender processoArquivoEmailSender, ModeloExporterService modeloExporterService, ProtocoloMapper protocoloMapper, ParametroService parametroService) {
        this.processoArquivoService = processoArquivoService;
        this.processoPesquisaService = processoPesquisaService;
        this.entidadeService = entidadeService;
        this.processoArquivoRepository = processoArquivoRepository;
        this.processoArquivoEmailSender = processoArquivoEmailSender;
        this.modeloExporterService = modeloExporterService;
        this.protocoloMapper = protocoloMapper;
        this.parametroService = parametroService;
    }

    @PostMapping(value={"/arquivo/upload"})
    public ResponseEntity<ArquivoDTO> addEloArquivo(@RequestParam(value="file") MultipartFile file) {
        return ResponseEntity.ok((Object)this.processoArquivoService.addEloArquivo(file));
    }

    @PostMapping(value={"/cloud/arquivo/upload"})
    public ResponseEntity<ArquivoDTO> addEloArquivoCloud(@RequestBody ArquivoUrl arquivoUrl, @RequestParam String fileName, @RequestParam String contentType) {
        return ResponseEntity.ok((Object)this.processoArquivoService.addEloArquivo(arquivoUrl, fileName, contentType));
    }

    @PostMapping(value={"/arquivo", "/arquivo/documento/{documento}"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<ProcessoDTO> addArquivo(@RequestParam(value="files") MultipartFile file, @PathVariable(name="documento", required=false) Long documento, @RequestParam(value="hasSignatures", required=false) Boolean hasSignatures, PesquisaProcessoParams params) throws IOException, InterruptedException {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Boolean isMaskCPF = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CPF_LGPD.getCodigo());
        Boolean isMaskCNPJ = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CNPJ_LGPD.getCodigo());
        Boolean isMaskUser = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_USUARIO_COM_MASCARA_COM_CPF_LGPD.getCodigo());
        Boolean isOrdemCrescenteAnexo = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_CRESCENTE_ANEXO.getCodigo());
        Boolean isOrdemDecrescenteApenasCampoCalculado = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_DECRESCENTE_ANEXO.getCodigo());
        Processo processo = this.loadProcesso(params);
        this.processoArquivoService.addArquivo(processo, auth.getName(), file, documento, Boolean.FALSE, Boolean.FALSE, Boolean.valueOf(false), hasSignatures);
        return ResponseEntity.ok((Object)new ProcessoDTOConverter().to(this.loadProcesso(params), isMaskCPF, isMaskCNPJ, isMaskUser, isOrdemCrescenteAnexo, isOrdemDecrescenteApenasCampoCalculado));
    }

    @Transactional
    @PostMapping(value={"/cloud/arquivo", "/cloud/arquivo/documento/{documento}"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<ProcessoDTO> addArquivoEntity(@RequestBody ArquivoUrl file, @RequestParam(value="fileName") String fileName, @RequestParam(value="contentType", required=false) String contentType, @RequestParam(value="hasSignatures", required=false) Boolean hasSignatures, @PathVariable(name="documento", required=false) Long documento, PesquisaProcessoParams params) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Boolean isMaskCPF = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CPF_LGPD.getCodigo());
        Boolean isMaskCNPJ = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CNPJ_LGPD.getCodigo());
        Boolean isMaskUser = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_USUARIO_COM_MASCARA_COM_CPF_LGPD.getCodigo());
        Boolean isOrdemCrescenteAnexo = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_CRESCENTE_ANEXO.getCodigo());
        Boolean isOrdemDecrescenteApenasCampoCalculado = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBIR_ORDEM_DECRESCENTE_ANEXO.getCodigo());
        Processo processo = this.loadProcesso(params);
        this.processoArquivoService.addArquivoEntity(processo, auth.getName(), file, fileName, contentType, documento, hasSignatures);
        return ResponseEntity.ok((Object)new ProcessoDTOConverter().to(this.loadProcesso(params), isMaskCPF, isMaskCNPJ, isMaskUser, isOrdemCrescenteAnexo, isOrdemDecrescenteApenasCampoCalculado));
    }

    @Transactional
    @PutMapping(value={"/analisar"})
    public ResponseEntity<ProcessoArquivo> analisar(@RequestBody AnaliseArquivoDTO analise) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        ProcessoArquivo arquivo = this.processoArquivoRepository.findByIdentificador(analise.getIdentificador());
        if (Objects.isNull(arquivo)) {
            throw RestException.notFound((String)"Arquivo n\u00e3o foi encontrado pelo identificador.");
        }
        arquivo.analisarArquivo(analise, auth.getName());
        if (AnaliseArquivoEnum.RECUSADO.equals((Object)arquivo.getAnalise())) {
            this.processoArquivoEmailSender.enviarEmailArquivoRecusado(arquivo);
        }
        return ResponseEntity.ok((Object)((ProcessoArquivo)this.processoArquivoRepository.saveAndFlush((Object)arquivo)));
    }

    @PostMapping(value={"/template"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<ProcessoDTO> adicionarTemplate(@RequestBody ArquivoTemplateDTO arquivo, PesquisaProcessoParams params) throws IOException, InterruptedException {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Processo processo = this.loadProcesso(params);
        ByteMultipartFile byteMultipartFile = new ByteMultipartFile(arquivo.getContentHtml().getBytes(StandardCharsets.UTF_8), "text/html", arquivo.getNome().concat(".html"));
        return ResponseEntity.ok((Object)this.processoArquivoService.addArquivo(processo, auth.getName(), (MultipartFile)byteMultipartFile, null, Boolean.FALSE, Boolean.TRUE, Boolean.valueOf(false), Boolean.valueOf(false)));
    }

    @PostMapping(value={"/template-pdf/{id}"})
    public ResponseEntity<ProcessoDTO> adicionarPdfDoTemplate(@PathVariable(value="id") String uuid, @RequestBody FileExportExecutorDTO fileExportExecutorDTO) throws IOException, InterruptedException {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Processo processo = this.processoPesquisaService.findByUuid(uuid);
        Optional abstractItextPdfView = this.modeloExporterService.exportPdfView(fileExportExecutorDTO);
        if (abstractItextPdfView.isEmpty()) {
            throw new ExportacaoException("PDF");
        }
        ByteArrayOutputStream byteArrayOutputStream = ((AbstractItextPdfView)abstractItextPdfView.get()).buildByteArrayOutputStreamPdfDocument();
        ByteMultipartFile byteMultipartFile = new ByteMultipartFile(byteArrayOutputStream.toByteArray(), "application/pdf", fileExportExecutorDTO.getName().concat(".pdf"));
        return ResponseEntity.ok((Object)this.processoArquivoService.addArquivo(processo, auth.getName(), (MultipartFile)byteMultipartFile, null, Boolean.FALSE, Boolean.FALSE, Boolean.valueOf(false), Boolean.valueOf(false)));
    }

    @Transactional
    @PutMapping(value={"/atualizar-arquivos"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<Void> atualizarArquivos(@RequestBody List<ProcessoArquivoDTO> arquivos, PesquisaProcessoParams params) {
        Processo processo = this.loadProcesso(params);
        this.processoArquivoService.atualizarArquivos(processo, arquivos);
        return ResponseEntity.ok().build();
    }

    private Processo loadProcesso(PesquisaProcessoParams params) {
        Processo processo = this.processoPesquisaService.loadProcesso(new Entidade(params.getEntidade()), params.getTipo(), params.getNumero(), params.getAno());
        if (Objects.isNull(processo)) {
            throw RestException.notFound((String)"Processo n\u00e3o localizado.");
        }
        return processo;
    }

    @GetMapping(value={"/find-by-identificador/{identificador}"})
    public ResponseEntity<ProcessoArquivoDTO> findByIdentificador(@PathVariable(value="identificador") String identificador) {
        return ResponseEntity.ok((Object)this.protocoloMapper.toProcessoArquivoDTO(this.processoArquivoService.findByIdentificador(identificador)));
    }

    @PostMapping(value={"/arquivos/zip/gerar-arquivos"}, produces={"application/octet-stream"})
    public ResponseEntity<byte[]> gerarProcessoArquivosZip(@RequestBody ProcessoArquivoZipDTO arquivos, HttpServletResponse response) throws IOException {
        File arquivo = this.processoArquivoService.gerarZipProcessoArquivo(arquivos);
        byte[] bytes = FileUtils.readFileToByteArray((File)arquivo);
        FileUtils.forceDelete((File)arquivo);
        response.setContentType("application/zip");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(HeaderUtils.createFileResponseHeaders((MediaType)MediaType.APPLICATION_OCTET_STREAM, (String)arquivo.getName(), (String)"zip"))).body((Object)bytes);
    }

    @PutMapping(value={"/cancelar-arquivo/{identificador}"})
    public ResponseEntity<Void> cancelarArquivo(@PathVariable(value="identificador") String identificador, @RequestBody String motivo) throws IOException {
        if (StringUtils.isBlank((CharSequence)motivo)) {
            throw new EloValidationException("\u00c9 obrigat\u00f3rio informar um motivo");
        }
        this.processoArquivoService.cancelarArquivo(identificador, motivo);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/arquivo/imprimir/{identificador}"})
    public void imprimirArquivo(@PathVariable(value="identificador") String identificador, ServletRequest request, HttpServletResponse response) throws IOException {
        ShallowEtagHeaderFilter.disableContentCaching((ServletRequest)request);
        response.setHeader("Transfer-Encoding", "chunked");
        response.setBufferSize(8192);
        this.processoArquivoService.imprimirArquivo(identificador, response);
    }
}

