/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProtocoloMapper;
import br.com.elotech.protocolo.dto.AnexarProcessosDTO;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.service.ProcessoAnexoService;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessoAnexoResource {
    private final ProcessoAnexoService service;
    private final ProcessoPesquisaService processoPesquisaService;
    private final ProtocoloMapper mapper;

    public ProcessoAnexoResource(ProcessoAnexoService service, ProcessoPesquisaService processoPesquisaService, ProtocoloMapper mapper) {
        this.service = service;
        this.processoPesquisaService = processoPesquisaService;
        this.mapper = mapper;
    }

    @PostMapping(value={"/api/processos/anexos"})
    public ResponseEntity<AnexarProcessosDTO> anexar(@RequestBody AnexarProcessosDTO dto) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Processo processoAnexo = this.processoPesquisaService.loadProcesso(Entidade.of((Long)dto.getProcessoAnexo().getEntidade().getId()), dto.getProcessoAnexo().getTipo().getId(), dto.getProcessoAnexo().getNumero(), dto.getProcessoAnexo().getAno());
        Processo processo = this.processoPesquisaService.loadProcesso(Entidade.of((Long)dto.getProcesso().getEntidade().getId()), dto.getProcesso().getTipo().getId(), dto.getProcesso().getNumero(), dto.getProcesso().getAno());
        this.service.anexarProcesso(processo, processoAnexo, authentication.getName());
        return ResponseEntity.ok().body((Object)dto);
    }

    @DeleteMapping(value={"/api/processos/anexos"})
    public ResponseEntity<Void> deleteAnexo(@RequestBody AnexarProcessosDTO dto) {
        Entidade entidade = Entidade.of((Long)dto.getProcessoAnexo().getEntidade().getId());
        Processo processoAnexo = this.processoPesquisaService.loadProcesso(entidade, dto.getProcessoAnexo().getTipo().getId(), dto.getProcessoAnexo().getNumero(), dto.getProcessoAnexo().getAno());
        return this.service.removerProcessoAnexo(processoAnexo);
    }

    @GetMapping(value={"/api/processos/anexos"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<List<ProcessoDTO>> findProcessosAnexos(PesquisaProcessoParams params) {
        Entidade entidade = new Entidade(params.getEntidade());
        Processo processo = this.processoPesquisaService.loadProcesso(entidade, params.getTipo(), params.getNumero(), params.getAno());
        List processos = this.service.getProcessosAnexos(processo);
        List dto = processos.stream().map(arg_0 -> ((ProtocoloMapper)this.mapper).toProcessoDTO(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok().body(dto);
    }

    @GetMapping(value={"/api/processos/anexos/buscaProcessoPai"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<Boolean> findProcessoPai(PesquisaProcessoParams params) {
        Entidade entidade = new Entidade(params.getEntidade());
        Processo processo = this.processoPesquisaService.loadProcesso(entidade, params.getTipo(), params.getNumero(), params.getAno());
        return ResponseEntity.ok().body((Object)this.service.isProcessoAnexado(processo));
    }
}

