/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoAndamento;
import br.com.elotech.protocolo.dto.LocalUsuarioComunicacaoDTO;
import br.com.elotech.protocolo.dto.ProcessoAndamentoDTO;
import br.com.elotech.protocolo.dto.ProcessoArquivoDTO;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.service.ProcessoAndamentoService;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/processo-andamentos"})
public class ProcessoAndamentoResource
extends CrudResource<ProcessoAndamento, Long> {
    private final ProcessoAndamentoService service;
    private final ProcessoPesquisaService processoPesquisaService;

    public ProcessoAndamentoResource(ProcessoAndamentoService service, ProcessoPesquisaService processoPesquisaService) {
        this.service = service;
        this.processoPesquisaService = processoPesquisaService;
    }

    @GetMapping(value={"/dto"})
    public ResponseEntity<Page<ProcessoAndamentoDTO>> getAllDTO(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return ResponseEntity.ok((Object)this.service.getAllDTO(search, pageable, auth.getName()));
    }

    @PostMapping(params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<ProcessoAndamento> save(PesquisaProcessoParams params, @RequestBody ProcessoAndamento andamento) {
        Processo processo = this.processoPesquisaService.loadProcesso(Entidade.of((Long)params.getEntidade()), params.getTipo(), params.getNumero(), params.getAno());
        return ResponseEntity.ok((Object)this.service.save(processo, andamento));
    }

    @PutMapping(value={"/responder/{id}"})
    public ProcessoAndamento responder(@PathVariable(value="id") Long id, @RequestParam(required=true, name="resposta") String resposta, @RequestBody(required=false) List<ProcessoArquivoDTO> arquivos) {
        return this.service.responder(id, resposta, arquivos);
    }

    @PutMapping(value={"/{id}"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<ProcessoAndamento> update(@PathVariable(value="id") Long id, @RequestBody ProcessoAndamento atualizado) {
        return this.service.findById((Serializable)id).map(andamento -> ResponseEntity.ok((Object)this.service.update(andamento, atualizado))).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/numero-recomendado"})
    public ResponseEntity<Long> responder(@RequestParam(name="tipoAndamentoId") Long tipoAndamentoId, @RequestParam(name="ano") Long anoProcesso) {
        return ResponseEntity.ok((Object)this.service.getNumeroRecomendado(tipoAndamentoId, anoProcesso));
    }

    @PostMapping(value={"/andamento-comunicacao"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<Void> createAndamentoComunicacao(PesquisaProcessoParams params, @RequestBody LocalUsuarioComunicacaoDTO locaisUsuariosComunicacao) {
        Processo processo = this.processoPesquisaService.loadProcesso(new Entidade(params.getEntidade()), params.getTipo(), params.getNumero(), params.getAno());
        this.service.createAndamentoComunicacao(processo, locaisUsuariosComunicacao);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/{id}/aceite"})
    public ResponseEntity<Locale.Builder> update(@PathVariable(value="id") Long id, @RequestBody String resposta) {
        this.service.aceite(id, resposta);
        return ResponseEntity.ok().build();
    }
}

