/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.adm.service.AsyncContext;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.dto.AgrupamentoDTO;
import br.com.elotech.protocolo.dto.NotificacaoAgrupamentoDTO;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.enums.StatusAgrupamento;
import br.com.elotech.protocolo.service.EntidadeService;
import br.com.elotech.protocolo.service.ProcessoArquivoAgrupamentoService;
import br.com.elotech.protocolo.service.ProcessoArquivoAsyncService;
import br.com.elotech.protocolo.service.ProcessoArquivoService;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.protocolo.service.ProcessoService;
import br.com.elotech.protocolo.service.UsuarioService;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/processos-agrupamento"})
public class ProcessoAgrupamentoResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessoAgrupamentoResource.class);
    private final ProcessoPesquisaService processoPesquisaService;
    private final EntidadeService entidadeService;
    private final ProcessoArquivoAsyncService processoArquivoAsyncService;
    private final ProcessoArquivoAgrupamentoService agrupamentoService;
    private final ProcessoService processoService;
    private final ProcessoArquivoService processoArquivoService;
    private final UsuarioService usuarioService;

    public ProcessoAgrupamentoResource(ProcessoPesquisaService processoPesquisaService, EntidadeService entidadeService, ProcessoArquivoAsyncService processoArquivoAsyncService, ProcessoArquivoAgrupamentoService agrupamentoService, ProcessoService processoService, ProcessoArquivoService processoArquivoService, UsuarioService usuarioService) {
        this.processoPesquisaService = processoPesquisaService;
        this.entidadeService = entidadeService;
        this.processoArquivoAsyncService = processoArquivoAsyncService;
        this.agrupamentoService = agrupamentoService;
        this.processoService = processoService;
        this.processoArquivoService = processoArquivoService;
        this.usuarioService = usuarioService;
    }

    @PostMapping(value={"/agrupar-arquivos"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<Void> agruparArquivosEmUnicoPdf(@RequestBody AgrupamentoDTO agrupamentoDTO, PesquisaProcessoParams params) throws IOException, InterruptedException {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Entidade entidade = (Entidade)this.entidadeService.findOne((Serializable)params.getEntidade());
        if (Objects.isNull(entidade)) {
            throw RestException.notFound((String)"Entidade n\u00e3o localizada.");
        }
        Processo processo = this.processoPesquisaService.loadProcesso(entidade, params.getTipo(), params.getNumero(), params.getAno());
        if (StatusAgrupamento.PENDENTE.equals((Object)processo.getStatusAgrupamento())) {
            throw new EloValidationException("O Agrupamento de arquivos j\u00e1 est\u00e1 em andamento.");
        }
        this.processoArquivoService.permiteIncluirArquivoLocalAtual(processo, this.usuarioService.findUsuarioByName(auth.getName()));
        this.processoService.updateStatusAgrupamentoById(StatusAgrupamento.PENDENTE, processo.getId());
        this.callAsyncMontarDocumentoPdf(agrupamentoDTO, params, entidade, auth);
        return ResponseEntity.noContent().build();
    }

    public void callAsyncMontarDocumentoPdf(AgrupamentoDTO agrupamentoDTO, PesquisaProcessoParams params, Entidade entidade, Authentication auth) throws IOException, InterruptedException {
        this.processoArquivoAsyncService.montarDocumentoPdf(agrupamentoDTO, params, entidade, auth, AsyncContext.getContext());
    }

    @PutMapping(value={"/verificar-agrupamento"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<NotificacaoAgrupamentoDTO> verificarAgrupamentoPendente(PesquisaProcessoParams params) {
        Entidade entidade = (Entidade)this.entidadeService.findOne((Serializable)params.getEntidade());
        if (Objects.isNull(entidade)) {
            log.error("Entidade n\u00e3o localizada.");
            return ResponseEntity.noContent().build();
        }
        NotificacaoAgrupamentoDTO notificacaoAgrupamento = this.agrupamentoService.verificarAgrupamentoPendente(params, entidade);
        if (Objects.isNull(notificacaoAgrupamento)) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.ok((Object)notificacaoAgrupamento);
    }

    @GetMapping(value={"/existe-processo-em-agrupamento"}, params={"tipo", "numero", "ano", "entidade"})
    public ResponseEntity<Boolean> existeProcessoEmAgrupamento(PesquisaProcessoParams params) {
        Entidade entidade = (Entidade)this.entidadeService.findOne((Serializable)params.getEntidade());
        return ResponseEntity.ok((Object)this.agrupamentoService.existeProcessoEmAgrupamento(entidade, params));
    }
}

