/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.protocolo.domain.Entidade;
import br.com.elotech.protocolo.domain.Processo;
import br.com.elotech.protocolo.domain.ProcessoPK;
import br.com.elotech.protocolo.domain.Tramite;
import br.com.elotech.protocolo.dto.ConfigRestricao;
import br.com.elotech.protocolo.dto.Funcao;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.protocolo.dto.TramiteProcessosWrapper;
import br.com.elotech.protocolo.dto.params.PesquisaProcessoParams;
import br.com.elotech.protocolo.service.ProcessoAgrupadaoValidacaoService;
import br.com.elotech.protocolo.service.ProcessoPesquisaService;
import br.com.elotech.protocolo.service.ProcessoService;
import br.com.elotech.protocolo.service.ProcessoValidacaoService;
import br.com.elotech.protocolo.service.RestricaoService;
import br.com.elotech.protocolo.web.request.RequestHeaderHelper;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/processos-agrupados"})
public class ProcessoAgrupadoResource
extends BaseResourceDTO<Processo, ProcessoPK, ProcessoDTO> {
    private final ProcessoService processoService;
    private final RestricaoService restricaoService;
    private final ProcessoPesquisaService processoPesquisaService;
    private final ProcessoValidacaoService processoValidacaoService;
    private final ProcessoAgrupadaoValidacaoService processoAgrupadaoValidacaoService;

    public ProcessoAgrupadoResource(ProcessoService processoService, RestricaoService restricaoService, ProcessoPesquisaService processoPesquisaService, ProcessoValidacaoService processoValidacaoService, ProcessoAgrupadaoValidacaoService processoAgrupadaoValidacaoService) {
        this.processoService = processoService;
        this.restricaoService = restricaoService;
        this.processoPesquisaService = processoPesquisaService;
        this.processoValidacaoService = processoValidacaoService;
        this.processoAgrupadaoValidacaoService = processoAgrupadaoValidacaoService;
    }

    @GetMapping(params={"tipo", "numero", "ano"})
    public ResponseEntity<List<ProcessoDTO>> findProcesso(PesquisaProcessoParams params) {
        ConfigRestricao configRestricao = this.restricaoService.getConfigRestricao();
        List processos = this.getProcessosByFuncoes(configRestricao.getUsuario().getId(), params, (Set)Sets.newHashSet((Object[])new Funcao[]{Funcao.RECEBIDO, Funcao.ENCAMINHADO, Funcao.ARQUIVADO, Funcao.ABERTO}));
        if (processos.isEmpty()) {
            throw new RestException(HttpStatus.BAD_REQUEST, String.format("Usu\u00e1rio sem permiss\u00e3o no local atual do processo: %s/%s.", params.getNumero(), params.getAno()));
        }
        Processo processo = (Processo)processos.get(0);
        this.processoAgrupadaoValidacaoService.validarPagamentoTributos(processo);
        this.processoAgrupadaoValidacaoService.validarSigiloProcesso(processo, configRestricao);
        this.processoAgrupadaoValidacaoService.validarVinculoProcessoPai(processo);
        return ResponseEntity.ok((Object)this.collectionToDTO(processos));
    }

    @GetMapping(value={"/lote/{lote}"})
    public ResponseEntity<List<ProcessoDTO>> findProcessosByLote(@PathVariable Long lote) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        List processos = this.processoPesquisaService.getProcessosByLote(lote, auth.getName());
        List processosOrdenados = processos.stream().sorted(Comparator.comparing(p -> ((Tramite)p.getUltimoTramite().get()).getId().getSequencia())).collect(Collectors.toList());
        return ResponseEntity.ok((Object)this.collectionToDTO(processosOrdenados));
    }

    @PostMapping(value={"/tramitar-lote"})
    public ResponseEntity<List<ProcessoDTO>> tramitarProcessosEmLote(@RequestBody @Valid TramiteProcessosWrapper dto) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Entidade entidade = RequestHeaderHelper.getEntidadeContextHolder();
        List<Processo> processos = dto.getProcessos().stream().map(p -> this.processoPesquisaService.loadProcesso(Entidade.of((Long)p.getEntidade().getId()), p.getTipo().getId(), p.getNumero(), p.getAno())).collect(Collectors.toList());
        this.processoAgrupadaoValidacaoService.validarControleTramitacao(processos, dto.getFuncao());
        processos.forEach(arg_0 -> ((ProcessoAgrupadaoValidacaoService)this.processoAgrupadaoValidacaoService).validarVinculoProcessoPai(arg_0));
        this.processoValidacaoService.validarTramitacaoProcessoByFuncao(processos, dto.getFuncao());
        return ResponseEntity.ok((Object)this.collectionToDTO(this.processoService.tramitar(processos, dto, entidade, auth.getName())));
    }

    private List<Processo> getProcessosByFuncoes(String name, PesquisaProcessoParams params, Set<Funcao> funcoes) {
        return this.processoPesquisaService.getProcessosByFuncao(name, params.getTipo(), params.getNumero().toString(), params.getAno(), funcoes);
    }
}

