/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.protocolo.web.rest;

import br.com.elotech.adm.rsql.RsqlSpecification;
import br.com.elotech.adm.utils.SpecificationWithOrderBySimilarity;
import br.com.elotech.audit.domain.RevisionRecord;
import br.com.elotech.audit.reader.RevisionReader;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.web.rest.BaseResourceDTO;
import br.com.elotech.protocolo.converter.PessoaDTOConverter;
import br.com.elotech.protocolo.domain.ParametroEnum;
import br.com.elotech.protocolo.domain.Pessoa;
import br.com.elotech.protocolo.dto.PessoaDTO;
import br.com.elotech.protocolo.service.ParametroService;
import br.com.elotech.protocolo.service.PessoaService;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/pessoas"})
public class PessoaResource
extends BaseResourceDTO<Pessoa, Long, PessoaDTO> {
    private final RevisionReader reader;
    private final ParametroService parametroService;
    private final EntityManager em;

    private PessoaService getPessoaService() {
        return (PessoaService)this.getService();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<PessoaDTO> findOne(@PathVariable Long id) {
        return super.findOne((Serializable)id);
    }

    @GetMapping(value={"/duplicados/{cnpjcpf}"})
    public ResponseEntity<List<PessoaDTO>> duplicates(@PathVariable(value="cnpjcpf") String cnpjCpf) {
        if (!StringUtils.isEmpty((CharSequence)cnpjCpf)) {
            List pessoaPage = this.getPessoaService().getPessoaDuplicateByCpfCnpj(cnpjCpf);
            return ResponseEntity.ok().body((Object)this.collectionToDTO(pessoaPage));
        }
        return null;
    }

    @GetMapping(value={"/dto"})
    public ResponseEntity<Page<PessoaDTO>> findAllDTO(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        String rsqlFilter = "ativo==true";
        boolean useCustomOrdering = false;
        if (StringUtils.isNumeric((CharSequence)search)) {
            rsqlFilter = rsqlFilter.concat(" and (cnpjCpf==\"*%search%*\" or id==\"%search%\")");
        } else if (StringUtils.isNotBlank((CharSequence)search)) {
            rsqlFilter = rsqlFilter.concat(" and nome==\"*%search%*\"");
            useCustomOrdering = true;
        }
        if (Objects.nonNull(search)) {
            rsqlFilter = rsqlFilter.replace("%search%", search.replace("\"", ""));
        }
        RsqlSpecification spec = new RsqlSpecification(this.em, rsqlFilter);
        if (useCustomOrdering) {
            spec = new SpecificationWithOrderBySimilarity((Specification)spec, "nome", search);
            pageable = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize());
        }
        Page pessoasPage = this.getService().findAll((Specification)spec, pageable);
        PessoaDTOConverter pessoaDTOConverter = new PessoaDTOConverter();
        Boolean isMaskCPF = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CPF_LGPD.getCodigo());
        Boolean isMaskCNPJ = this.parametroService.getParamValueAsBoolean(ParametroEnum.EXIBE_NUMERO_DOCUMENTO_COM_MASCARA_CNPJ_LGPD.getCodigo());
        return ResponseEntity.ok((Object)pessoasPage.map(pessoa -> pessoaDTOConverter.to(pessoa, isMaskCPF, isMaskCNPJ)));
    }

    @PostMapping
    public ResponseEntity<PessoaDTO> save(@RequestBody @Valid PessoaDTO dto, Authentication authentication, UriComponentsBuilder builder, HttpServletRequest request) {
        return super.save((Object)dto, authentication, builder, request);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<PessoaDTO> update(@RequestBody @Valid PessoaDTO dto, @PathVariable(value="id") Long id, Authentication authentication) {
        return super.update((Object)dto, (Serializable)id, authentication);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> remove(@PathVariable(value="id") Long id) {
        return super.remove((Serializable)id);
    }

    @GetMapping(value={"/consultapessoa/{cnpjcpf}"})
    public ResponseEntity<PessoaDTO> findAllByAtivoIsTrueAndCnpjCpfOrderById(@PathVariable(value="cnpjcpf") String cnpjCpf) {
        List pessoas = this.getPessoaService().findAllByAtivoIsTrueAndCnpjCpfOrderById(cnpjCpf);
        PessoaDTO dto = this.collectionToDTO(pessoas).stream().findFirst().orElse(new PessoaDTO()).reducePessoaDto();
        return ResponseEntity.ok().body((Object)dto);
    }

    @GetMapping(value={"/cpfcnpj/{cnpjcpf}"})
    public ResponseEntity<Pessoa> findPessoaByCnpjCpf(@PathVariable(value="cnpjcpf") String cnpjCpf) {
        List listPessoa = this.getPessoaService().getPessoaByCnpjCpfOrderById(cnpjCpf);
        if (listPessoa.isEmpty()) {
            throw new RestException(HttpStatus.NO_CONTENT, "N\u00e3o foi encontrado nenhuma pessoa com este cpf/cnpj.");
        }
        return ResponseEntity.ok((Object)((Pessoa)listPessoa.get(0)));
    }

    @GetMapping(value={"/{id}/history"})
    public ResponseEntity<List<RevisionRecord>> findhistoryPessoa(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.reader.findHistory(Pessoa.class, (Serializable)id));
    }

    @Generated
    public PessoaResource(RevisionReader reader, ParametroService parametroService, EntityManager em) {
        this.reader = reader;
        this.parametroService = parametroService;
        this.em = em;
    }
}

